/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.LogKit;
import io.jboot.utils.StrUtil;
import io.jboot.utils.TypeDef;
import io.jboot.web.json.JsonBodyParseInterceptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class JsonUtil {
    public static String getString(String json, String key) {
        return JsonUtil.get(json, key, String.class);
    }

    public static String getString(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, String.class);
    }

    public static String getString(String json, String key, String defaultValue) {
        String value = JsonUtil.getString(json, key);
        return value != null ? value : defaultValue;
    }

    public static String getString(Object jsonObjectOrArray, String key, String defaultValue) {
        String value = JsonUtil.getString(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static Boolean getBool(String json, String key) {
        return JsonUtil.get(json, key, Boolean.class);
    }

    public static Boolean getBool(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Boolean.class);
    }

    public static boolean getBool(String json, String key, boolean defaultValue) {
        Boolean value = JsonUtil.getBool(json, key);
        return value != null ? value : defaultValue;
    }

    public static boolean getBool(Object jsonObjectOrArray, String key, boolean defaultValue) {
        Boolean value = JsonUtil.getBool(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static Integer getInt(String json, String key) {
        return JsonUtil.get(json, key, Integer.class);
    }

    public static Integer getInt(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Integer.class);
    }

    public static int getInt(String json, String key, int defaultValue) {
        Integer value = JsonUtil.getInt(json, key);
        return value != null ? value : defaultValue;
    }

    public static int getInt(Object jsonObjectOrArray, String key, int defaultValue) {
        Integer value = JsonUtil.getInt(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static Float getFloat(String json, String key) {
        return JsonUtil.get(json, key, Float.class);
    }

    public static Float getFloat(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Float.class);
    }

    public static float getFloat(String json, String key, float defaultValue) {
        Float value = JsonUtil.getFloat(json, key);
        return value != null ? value.floatValue() : defaultValue;
    }

    public static float getFloat(Object jsonObjectOrArray, String key, float defaultValue) {
        Float value = JsonUtil.getFloat(jsonObjectOrArray, key);
        return value != null ? value.floatValue() : defaultValue;
    }

    public static Double getDouble(String json, String key) {
        return JsonUtil.get(json, key, Double.class);
    }

    public static Double getDouble(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Double.class);
    }

    public static double getDouble(String json, String key, double defaultValue) {
        Double value = JsonUtil.getDouble(json, key);
        return value != null ? value : defaultValue;
    }

    public static double getDouble(Object jsonObjectOrArray, String key, double defaultValue) {
        Double value = JsonUtil.getDouble(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static Long getLong(String json, String key) {
        return JsonUtil.get(json, key, Long.class);
    }

    public static Long getLong(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Long.class);
    }

    public static long getLong(String json, String key, long defaultValue) {
        Long value = JsonUtil.getLong(json, key);
        return value != null ? value : defaultValue;
    }

    public static long getLong(Object jsonObjectOrArray, String key, long defaultValue) {
        Long value = JsonUtil.getLong(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static BigInteger getBigInteger(String json, String key) {
        return JsonUtil.get(json, key, BigInteger.class);
    }

    public static BigInteger getBigInteger(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, BigInteger.class);
    }

    public static BigInteger getBigInteger(String json, String key, BigInteger defaultValue) {
        BigInteger value = JsonUtil.getBigInteger(json, key);
        return value != null ? value : defaultValue;
    }

    public static BigInteger getBigInteger(Object jsonObjectOrArray, String key, BigInteger defaultValue) {
        BigInteger value = JsonUtil.getBigInteger(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static BigDecimal getBigDecimal(String json, String key) {
        return JsonUtil.get(json, key, BigDecimal.class);
    }

    public static BigDecimal getBigDecimal(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, BigDecimal.class);
    }

    public static BigDecimal getBigDecimal(String json, String key, BigDecimal defaultValue) {
        BigDecimal value = JsonUtil.getBigDecimal(json, key);
        return value != null ? value : defaultValue;
    }

    public static BigDecimal getBigDecimal(Object jsonObjectOrArray, String key, BigDecimal defaultValue) {
        BigDecimal value = JsonUtil.getBigDecimal(jsonObjectOrArray, key);
        return value != null ? value : defaultValue;
    }

    public static Date getDate(String json, String key) {
        return JsonUtil.get(json, key, Date.class);
    }

    public static Date getDate(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, Date.class);
    }

    public static Date getDate(String json, String key, Date defaultValue) {
        Date date = JsonUtil.get(json, key, Date.class);
        return date != null ? date : defaultValue;
    }

    public static Date getDate(Object jsonObjectOrArray, String key, Date defaultValue) {
        Date date = JsonUtil.get(jsonObjectOrArray, key, Date.class);
        return date != null ? date : defaultValue;
    }

    public static JSONObject getJSONObject(String json, String key) {
        return JsonUtil.get(json, key, JSONObject.class);
    }

    public static JSONObject getJSONObject(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, JSONObject.class);
    }

    public static JSONArray getJSONArray(String json, String key) {
        return JsonUtil.get(json, key, JSONArray.class);
    }

    public static JSONArray getJSONArray(Object jsonObjectOrArray, String key) {
        return JsonUtil.get(jsonObjectOrArray, key, JSONArray.class);
    }

    public static <T> T get(String json, String key, Class<T> clazz) {
        return JsonUtil.get(JsonUtil.getJsonObjectOrArray(json), key, clazz);
    }

    public static <T> T get(Object jsonObjectOrArray, String key, Class<T> clazz) {
        if (jsonObjectOrArray == null) {
            return null;
        }
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(jsonObjectOrArray, clazz, clazz, key);
        }
        catch (Exception e) {
            LogKit.error((String)e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T get(String json, String key, TypeDef<?> typeDef) {
        return JsonUtil.get(JsonUtil.getJsonObjectOrArray(json), key, typeDef);
    }

    public static <T> T get(Object jsonObjectOrArray, String key, TypeDef<?> typeDef) {
        if (jsonObjectOrArray == null) {
            return null;
        }
        try {
            return (T)JsonBodyParseInterceptor.parseJsonBody(jsonObjectOrArray, typeDef.getDefClass(), typeDef.getType(), key);
        }
        catch (Exception e) {
            LogKit.error((String)e.toString(), (Throwable)e);
            return null;
        }
    }

    public static Object getJsonObjectOrArray(String json) {
        if (StrUtil.isNotBlank(json)) {
            try {
                return JSON.parse((String)json);
            }
            catch (Exception e) {
                LogKit.error((String)e.toString(), (Throwable)e);
            }
        }
        return null;
    }
}

