/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.JFinal;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import io.jboot.utils.QuietlyUtil;
import io.jboot.utils.StrUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipFile;

public class FileUtil {
    public static String getSuffix(String fileName) {
        if (fileName != null && fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf("."));
        }
        return null;
    }

    public static String removePrefix(String src, String prefix) {
        if (src != null && src.startsWith(prefix)) {
            return src.substring(prefix.length());
        }
        return src;
    }

    public static String removeRootPath(String src) {
        return FileUtil.removePrefix(src, PathKit.getWebRootPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readString(File file) {
        String string;
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = fis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            string = new String(baos.toByteArray(), JFinal.me().getConstants().getEncoding());
        }
        catch (Exception e) {
            try {
                LogKit.error((String)e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fis, baos);
                throw throwable;
            }
            FileUtil.close(fis, baos);
            return null;
        }
        FileUtil.close(fis, baos);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            fos.write(string.getBytes(JFinal.me().getConstants().getEncoding()));
        }
        catch (Exception e) {
            try {
                LogKit.error((String)e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fos);
                throw throwable;
            }
            FileUtil.close(fos);
        }
        FileUtil.close(fos);
    }

    public static void close(Closeable ... closeable) {
        QuietlyUtil.closeQuietly(closeable);
    }

    public static void unzip(String zipFilePath) throws IOException {
        String targetPath = zipFilePath.substring(0, zipFilePath.lastIndexOf("."));
        FileUtil.unzip(zipFilePath, targetPath, true);
    }

    public static void unzip(String zipFilePath, String targetPath) throws IOException {
        FileUtil.unzip(zipFilePath, targetPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String zipFilePath, String targetPath, boolean safeUnzip) throws IOException {
        targetPath = FileUtil.getCanonicalPath(new File(targetPath));
        zipFile = new ZipFile(zipFilePath);
        try {
            entryEnum = zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                block10: {
                    os = null;
                    is = null;
                    try {
                        zipEntry = entryEnum.nextElement();
                        if (zipEntry.isDirectory()) break block10;
                        if (safeUnzip && FileUtil.isNotSafeFile(zipEntry.getName())) {
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var11_11) {
                        FileUtil.close(new Closeable[]{is, os});
                        throw var11_11;
                    }
                    FileUtil.close(new Closeable[]{is, os});
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        targetFile = new File(targetPath + File.separator + zipEntry.getName());
                        if (!safeUnzip || FileUtil.getCanonicalPath(targetFile).startsWith(targetPath)) ** GOTO lbl-1000
                    }
                    FileUtil.close(new Closeable[]{is, os});
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        if (!targetFile.getParentFile().exists()) {
                            targetFile.getParentFile().mkdirs();
                        }
                        os = new BufferedOutputStream(new FileOutputStream(targetFile));
                        is = zipFile.getInputStream(zipEntry);
                        buffer = new byte[4096];
                        readLen = 0;
                        while ((readLen = is.read(buffer, 0, 4096)) > 0) {
                            os.write(buffer, 0, readLen);
                        }
                    }
                }
                FileUtil.close(new Closeable[]{is, os});
            }
        }
        catch (Throwable var12_12) {
            FileUtil.close(new Closeable[]{zipFile});
            throw var12_12;
        }
        FileUtil.close(new Closeable[]{zipFile});
    }

    private static boolean isNotSafeFile(String name) {
        return (name = name.toLowerCase()).endsWith(".jsp") || name.endsWith(".jspx");
    }

    public static boolean isAbsolutePath(String path) {
        return StrUtil.isNotBlank(path) && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

