/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.kit.SyncWriteMap;
import io.jboot.utils.StrUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateUtil {
    public static String datePatternWithoutDividing = "yyyyMMdd";
    public static String datePattern = "yyyy-MM-dd";
    public static final String dateMinutePattern = "yyyy-MM-dd HH:mm";
    public static String datetimePattern = "yyyy-MM-dd HH:mm:ss";
    public static final String dateMillisecondPattern = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String dateCSTPattern = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static String dateChinesePattern = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String datetimeChinesePattern = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    private static final String[] WEEKS = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final ThreadLocal<HashMap<String, SimpleDateFormat>> TL = ThreadLocal.withInitial(() -> new HashMap());
    private static final Map<String, DateTimeFormatter> datetimeFormaters = new SyncWriteMap();

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter ret = datetimeFormaters.get(pattern);
        if (ret == null) {
            ret = DateTimeFormatter.ofPattern(pattern);
            datetimeFormaters.put(pattern, ret);
        }
        return ret;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat ret = TL.get().get(pattern);
        if (ret == null) {
            ret = dateCSTPattern.equals(pattern) ? new SimpleDateFormat(dateCSTPattern, Locale.US) : new SimpleDateFormat(pattern);
            TL.get().put(pattern, ret);
        }
        return ret;
    }

    public static String toDateString(Date date) {
        return DateUtil.toString(date, datePattern);
    }

    public static String toDateMinuteString(Date date) {
        return DateUtil.toString(date, dateMinutePattern);
    }

    public static String toDateTimeString(Date date) {
        return DateUtil.toString(date, datetimePattern);
    }

    public static String toDateMillisecondString(Date date) {
        return DateUtil.toString(date, dateMillisecondPattern);
    }

    public static String toString(Date date, String pattern) {
        return date == null ? null : DateUtil.getSimpleDateFormat(pattern).format(date);
    }

    public static String toString(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateUtil.getDateTimeFormatter(pattern));
    }

    public static String toString(LocalDate localDate, String pattern) {
        return localDate.format(DateUtil.getDateTimeFormatter(pattern));
    }

    public static String toString(LocalTime localTime, String pattern) {
        return localTime.format(DateUtil.getDateTimeFormatter(pattern));
    }

    public static Date parseDate(String dateString) {
        if (StrUtil.isBlank((String)dateString)) {
            return null;
        }
        dateString = dateString.trim();
        try {
            SimpleDateFormat sdf = DateUtil.getSimpleDateFormat(DateUtil.getPattern(dateString));
            try {
                return sdf.parse(dateString);
            }
            catch (ParseException ex) {
                if (dateString.contains(".") || dateString.contains("/")) {
                    dateString = dateString.replace(".", "-").replace("/", "-");
                    return sdf.parse(dateString);
                }
                throw ex;
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("The date format is not supported for the date string: " + dateString);
        }
    }

    private static String getPattern(String dateString) {
        int length = dateString.length();
        if (length == datetimePattern.length()) {
            return datetimePattern;
        }
        if (length == datePattern.length()) {
            return datePattern;
        }
        if (length == dateMinutePattern.length()) {
            return dateMinutePattern;
        }
        if (length == dateMillisecondPattern.length()) {
            return dateMillisecondPattern;
        }
        if (length == datePatternWithoutDividing.length()) {
            return datePatternWithoutDividing;
        }
        if (length == dateCSTPattern.length()) {
            return dateCSTPattern;
        }
        throw new IllegalArgumentException("The date format is not supported for the date string: " + dateString);
    }

    public static Date parseDate(String dateString, String pattern) {
        if (StrUtil.isBlank((String)dateString)) {
            return null;
        }
        try {
            return DateUtil.getSimpleDateFormat(pattern).parse(dateString.trim());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The date format is not supported for the date string: " + dateString);
        }
    }

    public static LocalDateTime parseLocalDateTime(String localDateTimeString, String pattern) {
        return LocalDateTime.parse(localDateTimeString, DateUtil.getDateTimeFormatter(pattern));
    }

    public static LocalDate parseLocalDate(String localDateString, String pattern) {
        return LocalDate.parse(localDateString, DateUtil.getDateTimeFormatter(pattern));
    }

    public static LocalTime parseLocalTime(String localTimeString, String pattern) {
        return LocalTime.parse(localTimeString, DateUtil.getDateTimeFormatter(pattern));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            date = new Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            date = new Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            date = new Date(date.getTime());
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date toDate(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date toDate(LocalDate localDate, LocalTime localTime) {
        if (localDate == null) {
            return null;
        }
        if (localTime == null) {
            localTime = LocalTime.of(0, 0, 0);
        }
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 24);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getStartOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartOfYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DateUtil.getStartOfToday().getTime() - 86400000L);
        return cal.getTime();
    }

    public static Date getStartOfNearest7Days() {
        return DateUtil.getStartOfNearestDays(7);
    }

    public static Date getStartOfNearestDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DateUtil.getStartOfToday().getTime() - 86400000L * (long)days);
        return cal.getTime();
    }

    public static Date getEndOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartOfThisWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getEndOfThisWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(DateUtil.getStartOfThisWeek());
        cal.add(7, 7);
        return cal.getTime();
    }

    public static Date getStartOfThisMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getEndOfThisMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        return cal.getTime();
    }

    public static Date getStartOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfThisMonth());
        cal.add(2, -1);
        return cal.getTime();
    }

    public static Date getStartOfThisQuarter() {
        Calendar cal = Calendar.getInstance();
        int currentMonth = cal.get(2) + 1;
        if (currentMonth <= 3) {
            cal.set(2, 0);
        } else if (currentMonth <= 6) {
            cal.set(2, 3);
        } else if (currentMonth <= 9) {
            cal.set(2, 6);
        } else if (currentMonth <= 12) {
            cal.set(2, 9);
        }
        cal.set(5, 0);
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfThisQuarter() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfThisQuarter());
        cal.add(2, 3);
        return cal.getTime();
    }

    public static Date getStartOfQuarter(int quarterNumber) {
        if (quarterNumber < 1 || quarterNumber > 4) {
            throw new IllegalArgumentException("quarterNumber must equals 1,2,3,4");
        }
        Calendar cal = Calendar.getInstance();
        if (quarterNumber == 1) {
            cal.set(2, 0);
        } else if (quarterNumber == 2) {
            cal.set(2, 3);
        } else if (quarterNumber == 3) {
            cal.set(2, 6);
        } else {
            cal.set(2, 9);
        }
        cal.set(5, 0);
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndOfQuarter(int quarterNumber) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfQuarter(quarterNumber));
        cal.add(2, 3);
        return cal.getTime();
    }

    public static Date getStartOfThisYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getEndOfThisYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfThisYear());
        cal.add(1, 1);
        return cal.getTime();
    }

    public static Date getStartOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getStartOfThisYear());
        cal.add(1, -1);
        return cal.getTime();
    }

    public static int diffSecond(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return Math.abs((int)((date1ms - date2ms) / 1000L));
    }

    public static int diffMinute(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return Math.abs((int)((date1ms - date2ms) / 60000L));
    }

    public static int diffHours(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return Math.abs((int)((date1ms - date2ms) / 3600000L));
    }

    public static int diffDays(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return Math.abs((int)((date1ms - date2ms) / 86400000L));
    }

    public static int diffWeeks(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return Math.abs((int)((date1ms - date2ms) / 604800000L));
    }

    public static int diffMonths(Date date1, Date date2) {
        int diffYears = DateUtil.diffYears(date1, date2) * 12;
        int number1 = DateUtil.getMonthNumber(date1);
        int number2 = DateUtil.getMonthNumber(date2);
        return Math.abs(diffYears + number1 - number2);
    }

    public static int diffYears(Date date1, Date date2) {
        int number1 = DateUtil.getYearNumber(date1);
        int number2 = DateUtil.getYearNumber(date2);
        return Math.abs(number1 - number2);
    }

    public static int getMonthNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getQuarterNumber(Date date) {
        int monthNumber = DateUtil.getMonthNumber(date);
        if (monthNumber >= 1 && monthNumber <= 3) {
            return 1;
        }
        if (monthNumber >= 4 && monthNumber <= 6) {
            return 2;
        }
        if (monthNumber >= 7 && monthNumber <= 9) {
            return 3;
        }
        return 4;
    }

    public static int getYearNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getDayOfYearNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getDayOfMonthNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfWeekNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getWeekOfYearNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getWeekOfMonthNumber(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(4);
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, minutes);
        return cal.getTime();
    }

    public static Date addHours(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, hours);
        return cal.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addWeeks(Date date, int weeks) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(3, weeks);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static boolean isAfter(Date self, Date other) {
        return self != null && other != null && self.getTime() > other.getTime();
    }

    public static boolean isBefore(Date self, Date other) {
        return self != null && other != null && self.getTime() < other.getTime();
    }

    public static boolean isSameDay(Date self, Date other) {
        return self != null && other != null && DateUtil.getYearNumber(self) == DateUtil.getYearNumber(other) && DateUtil.getDayOfYearNumber(self) == DateUtil.getDayOfYearNumber(other);
    }

    public static boolean isSameWeek(Date self, Date other) {
        return self != null && other != null && DateUtil.getYearNumber(self) == DateUtil.getYearNumber(other) && DateUtil.getWeekOfYearNumber(self) == DateUtil.getWeekOfYearNumber(other);
    }

    public static boolean isSameMonth(Date self, Date other) {
        return self != null && other != null && DateUtil.getYearNumber(self) == DateUtil.getYearNumber(other) && DateUtil.getMonthNumber(self) == DateUtil.getMonthNumber(other);
    }

    public static boolean isSameQuarter(Date self, Date other) {
        return self != null && other != null && DateUtil.getYearNumber(self) == DateUtil.getYearNumber(other) && DateUtil.getQuarterNumber(self) == DateUtil.getQuarterNumber(other);
    }

    public static boolean isSameYear(Date self, Date other) {
        return self != null && other != null && DateUtil.getYearNumber(self) == DateUtil.getYearNumber(other);
    }

    public static boolean isToday(Date date) {
        return DateUtil.isSameDay(new Date(), date);
    }

    public static boolean isThisWeek(Date date) {
        return DateUtil.isSameWeek(new Date(), date);
    }

    public static boolean isThisMonth(Date date) {
        return DateUtil.isSameMonth(new Date(), date);
    }

    public static boolean isThisQuarter(Date date) {
        return DateUtil.isSameQuarter(new Date(), date);
    }

    public static boolean isThisYear(Date date) {
        return date != null && DateUtil.getYearNumber(new Date()) == DateUtil.getYearNumber(date);
    }

    public static boolean isLeapYear(Date date) {
        return date != null && new GregorianCalendar().isLeapYear(DateUtil.getYearNumber(date));
    }

    public static String getWeekDay(Date date) {
        return date == null ? null : WEEKS[DateUtil.getDayOfWeekNumber(date) - 1];
    }

    public static void main(String[] args) {
        System.out.println("\u4e24\u5929\u540e\u7684\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfDay(DateUtil.addDays(new Date(), 2))));
        System.out.println("\u4e24\u5929\u540e\u7684\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfDay(DateUtil.addDays(new Date(), 2))));
        System.out.println("CST\u65f6\u95f4\u89e3\u6790\uff1a" + DateUtil.toDateTimeString(DateUtil.parseDate("Mon Sep 02 11:23:45 CST 2019")));
        System.out.println("\u5f53\u592924\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfToday()));
        System.out.println("\u5f53\u524d\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(new Date()));
        System.out.println("\u5f53\u59290\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfToday()));
        System.out.println("\u6628\u59290\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfYesterday()));
        System.out.println("\u8fd17\u5929\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfNearest7Days()));
        System.out.println("\u672c\u5468\u5468\u4e000\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfThisWeek()));
        System.out.println("\u672c\u5468\u5468\u65e524\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfThisWeek()));
        System.out.println("\u672c\u6708\u521d0\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfThisMonth()));
        System.out.println("\u672c\u6708\u672a24\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfThisMonth()));
        System.out.println("\u4e0a\u6708\u521d0\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfLastMonth()));
        System.out.println("\u672c\u5b63\u5ea6\u5f00\u59cb\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfThisQuarter()));
        System.out.println("\u672c\u5b63\u5ea6\u7ed3\u675f\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfThisQuarter()));
        System.out.println("\u672c\u5e74\u5f00\u59cb\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfThisYear()));
        System.out.println("\u672c\u5e74\u7ed3\u675f\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfThisYear()));
        System.out.println("\u4e0a\u5e74\u5f00\u59cb\u70b9\u65f6\u95f4\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfLastYear()));
        System.out.println("=============");
        System.out.println("\u79d2\u95f4\u9694\uff1a" + DateUtil.diffSecond(DateUtil.parseDate("2020-02-11 12:21:55"), DateUtil.parseDate("2020-02-11 12:22:58")));
        System.out.println("\u5206\u949f\u95f4\u9694\uff1a" + DateUtil.diffMinute(DateUtil.parseDate("2020-02-11 12:21:55"), DateUtil.parseDate("2020-02-11 12:22:01")));
        System.out.println("\u5c0f\u65f6\u95f4\u9694\uff1a" + DateUtil.diffHours(DateUtil.parseDate("2020-02-11 12:21:55"), DateUtil.parseDate("2020-02-12 12:22:01")));
        System.out.println("\u5929\u95f4\u9694\uff1a" + DateUtil.diffDays(DateUtil.parseDate("2020-02-11 12:21:55"), DateUtil.parseDate("2020-02-12 12:22:01")));
        System.out.println("\u661f\u671f\u95f4\u9694\uff1a" + DateUtil.diffWeeks(DateUtil.parseDate("2020-01-11 12:21:55"), DateUtil.parseDate("2020-02-12 12:22:01")));
        System.out.println("\u6708\u95f4\u9694\uff1a" + DateUtil.diffMonths(DateUtil.parseDate("2019-10-11 12:21:55"), DateUtil.parseDate("2020-09-11 12:21:55")));
        System.out.println("\u5e74\u95f4\u9694\uff1a" + DateUtil.diffYears(DateUtil.parseDate("1990-01-11 12:21:55"), DateUtil.parseDate("2020-02-12 12:22:01")));
        System.out.println("\u5f53\u524d\u5e74\u4efd\uff1a" + DateUtil.getYearNumber(new Date()));
        System.out.println("\u5f53\u524d\u6708\u4efd\uff1a" + DateUtil.getMonthNumber(new Date()));
        System.out.println("=============");
        System.out.println("\u65b0\u589e\u79d2\uff1a" + DateUtil.toDateTimeString(DateUtil.addSeconds(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("\u65b0\u589e\u5206\u949f\uff1a" + DateUtil.toDateTimeString(DateUtil.addMinutes(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("\u65b0\u589e\u5c0f\u65f6\uff1a" + DateUtil.toDateTimeString(DateUtil.addHours(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("\u65b0\u589e\u5929\uff1a" + DateUtil.toDateTimeString(DateUtil.addDays(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("\u65b0\u589e\u661f\u671f\uff1a" + DateUtil.toDateTimeString(DateUtil.addWeeks(DateUtil.parseDate("2020-02-11 12:21:55"), 10)));
        System.out.println("\u65b0\u589e\u6708\u4efd\uff1a" + DateUtil.toDateTimeString(DateUtil.addMonths(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("\u65b0\u589e\u5e74\u4efd\uff1a" + DateUtil.toDateTimeString(DateUtil.addYears(DateUtil.parseDate("2020-02-11 12:21:55"), 20)));
        System.out.println("=============");
        System.out.println("\u4eca\u5929\u661f\u671f\uff1a" + DateUtil.getWeekDay(DateUtil.parseDate("2020-11-24")));
        System.out.println("isToday\uff1a" + DateUtil.isToday(DateUtil.parseDate("2020-12-01")));
        System.out.println("isThisWeek\uff1a" + DateUtil.isThisWeek(DateUtil.parseDate("2020-11-24")));
        System.out.println("isThisMonth\uff1a" + DateUtil.isThisMonth(DateUtil.parseDate("2020-10-02")));
        System.out.println("isThisQuarter\uff1a" + DateUtil.isThisQuarter(DateUtil.parseDate("2020-10-02")));
        System.out.println("isThisYear\uff1a" + DateUtil.isThisYear(DateUtil.parseDate("2020-02-02")));
        System.out.println("\u7b2c1\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfQuarter(1)));
        System.out.println("\u7b2c2\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfQuarter(2)));
        System.out.println("\u7b2c3\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfQuarter(3)));
        System.out.println("\u7b2c4\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfQuarter(4)));
        System.out.println("\u672c\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getStartOfThisQuarter()));
        System.out.println("\u672c\u5b63\u5ea6\uff1a" + DateUtil.toDateTimeString(DateUtil.getEndOfThisQuarter()));
    }
}

