/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.Controller;
import com.jfinal.kit.Base64Kit;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import io.jboot.utils.StrUtil;
import io.jboot.web.JbootWebConfig;
import java.math.BigInteger;

public class CookieUtil {
    private static final Log LOG = Log.getLog(CookieUtil.class);
    private static final String COOKIE_SEPARATOR = "#";
    private static String COOKIE_ENCRYPT_KEY = JbootWebConfig.getInstance().getCookieEncryptKey();
    private static int COOKIE_MAX_AGE = JbootWebConfig.getInstance().getCookieMaxAge();
    private static String defaultPath = null;
    private static String defaultDomain = null;

    public static void initEncryptKey(String key) {
        COOKIE_ENCRYPT_KEY = key;
    }

    public static void initDefaultCookieMaxAge(int seconds) {
        COOKIE_MAX_AGE = seconds;
    }

    public static String getDefaultPath() {
        return defaultPath;
    }

    public static void setDefaultPath(String defaultPath) {
        CookieUtil.defaultPath = defaultPath;
    }

    public static String getDefaultDomain() {
        return defaultDomain;
    }

    public static void setDefaultDomain(String defaultDomain) {
        CookieUtil.defaultDomain = defaultDomain;
    }

    public static void put(Controller ctr, String key, Object value) {
        CookieUtil.put(ctr, key, value, COOKIE_MAX_AGE, defaultPath, defaultDomain, COOKIE_ENCRYPT_KEY);
    }

    public static void put(Controller ctr, String key, Object value, String secretKey) {
        CookieUtil.put(ctr, key, value, COOKIE_MAX_AGE, defaultPath, defaultDomain, secretKey);
    }

    public static void put(Controller ctr, String key, String value, int maxAgeInSeconds) {
        CookieUtil.put(ctr, key, value, maxAgeInSeconds, defaultPath, defaultDomain, COOKIE_ENCRYPT_KEY);
    }

    public static void put(Controller ctr, String key, String value, int maxAgeInSeconds, String secretKey) {
        CookieUtil.put(ctr, key, value, maxAgeInSeconds, defaultPath, defaultDomain, secretKey);
    }

    public static void put(Controller ctr, String key, Object value, int maxAgeInSeconds, String path, String domain, String secretKey) {
        String cookie = CookieUtil.buildCookieValue(value.toString(), maxAgeInSeconds, secretKey);
        ctr.setCookie(key, cookie, maxAgeInSeconds, path, domain, true);
    }

    public static void remove(Controller ctr, String key) {
        ctr.removeCookie(key);
    }

    public static void remove(Controller ctr, String key, String path, String domain) {
        ctr.removeCookie(key, path, domain);
    }

    public static String get(Controller ctr, String key) {
        return CookieUtil.get(ctr, key, COOKIE_ENCRYPT_KEY);
    }

    public static String get(Controller ctr, String key, String secretKey) {
        String cookieValue = ctr.getCookie(key);
        if (cookieValue == null) {
            return null;
        }
        try {
            String value = new String(Base64Kit.decode((String)cookieValue));
            return CookieUtil.getFromCookieInfo(secretKey, value);
        }
        catch (Exception ex) {
            LogKit.error((String)ex.toString(), (Throwable)ex);
            return null;
        }
    }

    public static String buildCookieValue(String value, int maxAgeInSeconds, String secretKey) {
        long saveTime = System.currentTimeMillis();
        String encryptValue = CookieUtil.encrypt(secretKey, saveTime, maxAgeInSeconds, value);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(encryptValue);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(saveTime);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(maxAgeInSeconds);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(Base64Kit.encode((String)value));
        return Base64Kit.encode((String)stringBuilder.toString());
    }

    private static String encrypt(String secretKey, Object saveTime, Object maxAgeInSeconds, String value) {
        if ("JBOOT_DEFAULT_ENCRYPT_KEY".equals(secretKey)) {
            LOG.warn("warn!!! encrypt key is defalut value. please config \"jboot.web.cookieEncryptKey = xxx\" in jboot.properties ");
        }
        return HashKit.md5((String)(secretKey + saveTime.toString() + maxAgeInSeconds.toString() + value));
    }

    public static String getFromCookieInfo(String secretKey, String cookieValue) {
        if (StrUtil.isBlank((String)cookieValue)) {
            return null;
        }
        String[] cookieStrings = cookieValue.split(COOKIE_SEPARATOR);
        if (cookieStrings.length != 4) {
            return null;
        }
        String encryptValue = cookieStrings[0];
        String saveTime = cookieStrings[1];
        String maxAgeInSeconds = cookieStrings[2];
        String value = Base64Kit.decodeToStr((String)cookieStrings[3]);
        String encrypt = CookieUtil.encrypt(secretKey, Long.valueOf(saveTime), maxAgeInSeconds, value);
        if (!encrypt.equals(encryptValue)) {
            return null;
        }
        long maxTimeMillis = Long.parseLong(maxAgeInSeconds) * 1000L;
        if (maxTimeMillis <= 0L) {
            return value;
        }
        long saveTimeMillis = Long.parseLong(saveTime);
        if (saveTimeMillis + maxTimeMillis - System.currentTimeMillis() > 0L) {
            return value;
        }
        return null;
    }

    public static Long getLong(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : Long.valueOf(Long.parseLong(value));
    }

    public static long getLong(Controller ctr, String key, long defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : Long.parseLong(value);
    }

    public static Integer getInt(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static int getInt(Controller ctr, String key, int defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : Integer.parseInt(value);
    }

    public static BigInteger getBigInteger(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : new BigInteger(value);
    }

    public static BigInteger getBigInteger(Controller ctr, String key, BigInteger defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : new BigInteger(value);
    }
}

