/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.app.config.JbootConfigKit;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.annotation.ConfigModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ConfigUtil {
    public static <T> Map<String, T> getConfigModels(Class<T> tClass) {
        ConfigModel configModel = tClass.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            throw new IllegalStateException("The Class \"" + tClass.getName() + "\" is not have @ConfigModel annotation");
        }
        return ConfigUtil.getConfigModels(tClass, configModel.prefix());
    }

    public static <T> Map<String, T> getConfigModels(Class<T> tClass, String prefix) {
        return ConfigUtil.getConfigModels(JbootConfigManager.me(), tClass, prefix);
    }

    public static <T> Map<String, T> getConfigModels(JbootConfigManager configManager, Class<T> tClass) {
        ConfigModel configModel = tClass.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            throw new IllegalStateException("The Class \"" + tClass.getName() + "\" is not have @ConfigModel annotation");
        }
        return ConfigUtil.getConfigModels(configManager, tClass, configModel.prefix());
    }

    public static <T> Map<String, T> getConfigModels(JbootConfigManager configManager, Class<T> tClass, String prefix) {
        HashMap<String, T> objMap = new HashMap<String, T>();
        boolean initDefault = false;
        HashSet<String> objNames = new HashSet<String>();
        String objPrefix = prefix + ".";
        int pointCount = StringUtils.countMatches((CharSequence)prefix, (char)'.');
        Properties prop = configManager.getProperties();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String[] keySplits;
            if (entry.getKey() == null || JbootConfigKit.isBlank(entry.getKey().toString())) continue;
            String key = entry.getKey().toString().trim();
            if (key.contains("_") && Character.isUpperCase(key.charAt(0))) {
                key = key.toLowerCase().replace('_', '.');
            }
            if (!initDefault && key.startsWith(prefix) && StringUtils.countMatches((CharSequence)key, (char)'.') == pointCount + 1) {
                initDefault = true;
                T defaultObj = configManager.get(tClass, prefix, null);
                objMap.put("default", defaultObj);
            }
            if (!key.startsWith(objPrefix) || entry.getValue() == null || (keySplits = key.split("\\.")).length != pointCount + 3) continue;
            objNames.add(keySplits[pointCount + 1]);
        }
        for (String name : objNames) {
            T obj = configManager.get(tClass, objPrefix + name, null);
            objMap.put(name, obj);
        }
        return objMap;
    }
}

