/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.aop.Aop;
import com.jfinal.log.Log;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.exception.JbootException;
import io.jboot.utils.ClassType;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil {
    private static Log LOG = Log.getLog(ClassUtil.class);
    private static final Map<Class<?>, Object> singletons = new ConcurrentHashMap();
    private static final String ENHANCER_BY = "$$EnhancerBy";
    private static final String JAVASSIST_BY = "_$$_";

    public static <T> T singleton(Class<T> clazz) {
        return ClassUtil.singleton(clazz, true);
    }

    public static synchronized <T> T singleton(Class<T> clazz, boolean createByAop) {
        Object ret = singletons.get(clazz);
        if (ret == null) {
            ret = ClassUtil.newInstance(clazz, createByAop);
            if (ret != null) {
                singletons.put(clazz, ret);
            } else {
                LOG.error("cannot new newInstance!!!!");
            }
        }
        return (T)ret;
    }

    public static synchronized <T> T singleton(Class<T> clazz, boolean createByAop, boolean inject) {
        Object ret = singletons.get(clazz);
        if (ret == null) {
            ret = ClassUtil.newInstance(clazz, createByAop);
            if (ret != null) {
                if (inject && !createByAop) {
                    Aop.inject((Object)ret);
                }
                singletons.put(clazz, ret);
            } else {
                LOG.error("cannot new newInstance!!!!");
            }
        }
        return (T)ret;
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ClassUtil.newInstance(clazz, true);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... paras) {
        return ClassUtil.newInstance(clazz, true, paras);
    }

    public static <T> T newInstance(Class<T> clazz, boolean createByAop) {
        if (createByAop) {
            return (T)Aop.get(clazz);
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, boolean createByAop, Object ... paras) {
        try {
            Class[] classes = new Class[paras.length];
            for (int i = 0; i < paras.length; ++i) {
                Object data = paras[i];
                if (data == null) {
                    throw new IllegalArgumentException("paras must not null");
                }
                classes[i] = data.getClass();
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            T ret = constructor.newInstance(paras);
            if (createByAop) {
                Aop.inject(ret);
            }
            return ret;
        }
        catch (Exception e) {
            LOG.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz) {
        StaticConstruct staticConstruct = clazz.getAnnotation(StaticConstruct.class);
        if (staticConstruct == null) {
            return null;
        }
        return ClassUtil.newInstanceByStaticConstruct(clazz, staticConstruct);
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz, StaticConstruct staticConstruct) {
        Method method = ClassUtil.getStaticConstruct(staticConstruct.value(), clazz);
        if (method == null) {
            throw new JbootException("Can not new instance by static constrauct for class: " + clazz);
        }
        try {
            return (T)method.invoke(null, null);
        }
        catch (Exception e) {
            LOG.error("Can not invoke method:" + method.getName() + " in class : " + clazz + "\n" + e, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static Method getStaticConstruct(String name, Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != clazz) continue;
            if (StrUtil.isBlank((String)name)) {
                return method;
            }
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static <T> T newInstance(String clazzName) {
        return ClassUtil.newInstance(clazzName, true);
    }

    public static <T> T newInstance(String clazzName, boolean createByAop) {
        return ClassUtil.newInstance(clazzName, createByAop, Thread.currentThread().getContextClassLoader());
    }

    public static <T> T newInstance(String clazzName, boolean createByAop, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(clazzName, false, classLoader);
            return (T)ClassUtil.newInstance(clazz, createByAop);
        }
        catch (Exception e) {
            LOG.error("can not newInstance class:" + clazzName + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static Class getUsefulClass(Class<?> clazz) {
        String name = clazz.getName();
        if (name.contains(ENHANCER_BY) || name.contains(JAVASSIST_BY)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static ClassType getClassType(Type type, Class<?> runClass) {
        if (type instanceof Class) {
            return new ClassType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ClassType classType = new ClassType((Class)((ParameterizedType)type).getRawType());
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            ClassType[] genericTypes = new ClassType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                genericTypes[i] = ClassUtil.getClassType(actualTypeArguments[i], runClass);
            }
            classType.setGenericTypes(genericTypes);
            return classType;
        }
        if (type instanceof TypeVariable && runClass != null) {
            Type variableRawType = ClassUtil.getTypeInClassDefined(runClass, (TypeVariable)type);
            if (variableRawType != null) {
                return ClassUtil.getClassType(variableRawType, runClass);
            }
            return null;
        }
        return null;
    }

    private static Type getTypeInClassDefined(Class<?> runClass, TypeVariable<?> typeVariable) {
        Type type = runClass.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArguments.length == 1) {
                return typeArguments[0];
            }
            if (typeArguments.length > 1) {
                TypeVariable<?>[] typeVariables = typeVariable.getGenericDeclaration().getTypeParameters();
                for (int i = 0; i < typeVariables.length; ++i) {
                    if (!typeVariable.getName().equals(typeVariables[i].getName())) continue;
                    return typeArguments[i];
                }
            }
        }
        return null;
    }

    public static String buildMethodString(Method method) {
        StringBuilder sb = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(",");
        }
        return sb.append(")").toString();
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className, false, ClassUtil.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : ClassUtil.class.getClassLoader();
    }
}

