/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import java.io.Serializable;

public class ClassType
implements Serializable {
    private Class<?> mainClass;
    private ClassType[] genericTypes;

    public ClassType() {
    }

    public ClassType(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    public ClassType(Class<?> mainClass, Class<?>[] genericClasses) {
        this.mainClass = mainClass;
        if (genericClasses != null && genericClasses.length > 0) {
            this.genericTypes = new ClassType[genericClasses.length];
            for (int i = 0; i < genericClasses.length; ++i) {
                this.genericTypes[i] = new ClassType(genericClasses[i]);
            }
        }
    }

    public ClassType(Class<?> mainClass, ClassType[] genericTypes) {
        this.mainClass = mainClass;
        this.genericTypes = genericTypes;
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(Class<?> mainClass) {
        this.mainClass = mainClass;
    }

    public ClassType[] getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(ClassType[] genericTypes) {
        this.genericTypes = genericTypes;
    }

    public String getDataType() {
        return this.mainClass.getSimpleName();
    }

    public boolean isGeneric() {
        return this.genericTypes != null && this.genericTypes.length > 0;
    }

    public boolean isVoid() {
        return this.mainClass == Void.TYPE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mainClass.getSimpleName());
        if (this.isGeneric()) {
            sb.append("<");
            for (int i = 0; i < this.genericTypes.length; ++i) {
                sb.append(this.genericTypes[i].toString());
                if (i == this.genericTypes.length - 1) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

