/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class MockServletInputStream
extends ServletInputStream {
    final byte[] myBytes;
    private int lastIndexRetrieved = -1;
    private ReadListener readListener = null;
    private int readLimit = -1;
    private int markedPosition = -1;

    public MockServletInputStream(byte[] myBytes) {
        this.myBytes = myBytes;
    }

    public MockServletInputStream(String content) {
        this.myBytes = content.getBytes(StandardCharsets.UTF_8);
    }

    public boolean isFinished() {
        return this.lastIndexRetrieved == this.myBytes.length - 1;
    }

    public boolean isReady() {
        return this.isFinished();
    }

    public int available() throws IOException {
        return this.myBytes.length - this.lastIndexRetrieved - 1;
    }

    public void close() throws IOException {
        this.lastIndexRetrieved = this.myBytes.length - 1;
    }

    public void setReadListener(ReadListener readListener) {
        this.readListener = readListener;
        if (!this.isFinished()) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        } else {
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readLimit) {
        this.readLimit = readLimit;
        this.markedPosition = this.lastIndexRetrieved;
    }

    public synchronized void reset() throws IOException {
        if (this.markedPosition == -1) {
            throw new IOException("No mark found");
        }
        this.lastIndexRetrieved = this.markedPosition;
        this.readLimit = -1;
    }

    public int read() throws IOException {
        if (!this.isFinished()) {
            byte i = this.myBytes[this.lastIndexRetrieved + 1];
            ++this.lastIndexRetrieved;
            if (this.isFinished() && this.readListener != null) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException ex) {
                    this.readListener.onError((Throwable)ex);
                    throw ex;
                }
                this.readLimit = -1;
            }
            if (this.readLimit != -1 && this.lastIndexRetrieved - this.markedPosition > this.readLimit) {
                this.markedPosition = -1;
                this.readLimit = -1;
            }
            return i;
        }
        return -1;
    }
}

