/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test.web;

import com.jfinal.core.JFinal;
import io.jboot.test.MockProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class MockHttpServletResponse
extends HttpServletResponseWrapper {
    protected String contentString;
    protected ByteArrayOutputStream stream = new ByteArrayOutputStream();
    protected PrintWriter writer;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Set<Cookie> cookies = new HashSet<Cookie>();
    protected int status = 200;
    protected String statusMessage = "OK";
    protected Locale locale;
    protected String contentType;
    protected String characterEncoding = JFinal.me().getConstants().getEncoding();

    public MockHttpServletResponse() {
        super(MockProxy.create(HttpServletResponse.class));
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public void addDateHeader(String key, long value) {
        this.headers.put(key, "" + value);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addIntHeader(String key, int value) {
        this.headers.put(key, "" + value);
    }

    public boolean containsHeader(String key) {
        return this.headers.containsKey(key);
    }

    public void sendError(int status) throws IOException {
        this.setStatus(status);
    }

    public void sendError(int status, String statusMessage) throws IOException {
        this.setStatus(status, statusMessage);
    }

    public void sendRedirect(String value) throws IOException {
        if (this.status == 200) {
            this.setStatus(302);
        }
        this.headers.put("Location", value);
    }

    public void setDateHeader(String key, long value) {
        this.headers.put(key, "" + value);
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setIntHeader(String key, int value) {
        this.headers.put(key, "" + value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String statusMessage) {
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
    }

    public int getBufferSize() {
        return this.stream.size();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int arg0) throws IOException {
                MockHttpServletResponse.this.stream.write(arg0);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.characterEncoding));
        }
        return this.writer;
    }

    public void reset() {
        this.stream.reset();
    }

    public void resetBuffer() {
        this.stream.reset();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getContentString() {
        if (this.contentString == null) {
            try {
                this.getWriter().flush();
                this.contentString = this.stream.toString(this.characterEncoding);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.contentString;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public boolean isCommitted() {
        return false;
    }
}

