/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test.web;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.jfinal.kit.LogKit;
import io.jboot.test.web.MockHttpSession;
import io.jboot.test.web.MockServletContext;
import io.jboot.test.web.MockServletInputStream;
import io.jboot.utils.StrUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class MockHttpServletRequest
implements HttpServletRequest {
    protected String contextPath;
    protected String method = "GET";
    protected String pathInfo;
    protected String pathTranslated;
    protected String queryString = "";
    protected String requestURI;
    protected String servletPath;
    protected String characterEncoding = "UTF-8";
    protected String protocol = "HTTP/1.1";
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    protected String remoteUser;
    protected String authType;
    protected Principal userPrincipal;
    protected StringBuffer requestURL;
    protected HttpSession session;
    protected ServletInputStream inputStream;
    private byte[] content;
    protected ServletContext servletContext = MockServletContext.DEFAULT;
    protected HttpServletResponse response;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, Object> attributeMap = new HashMap<String, Object>();
    protected Map<String, String[]> parameters = new HashMap<String, String[]>();
    protected Set<Cookie> cookies = new HashSet<Cookie>();
    protected LinkedList<Locale> locales = new LinkedList();
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    private final Set<String> userRoles = new HashSet<String>();
    private final Multimap<String, Part> parts = LinkedHashMultimap.create();

    public String getContextPath() {
        if (this.contextPath == null) {
            this.contextPath = this.servletContext.getContextPath();
        }
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public void setHeaders(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((s, s2) -> this.headers.put(s.toLowerCase(), (String)s2));
        }
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name.toLowerCase(), value.toString());
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(StringBuffer requestURL) {
        this.requestURL = requestURL;
    }

    public String getRequestedSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        if (this.requestURI == null) {
            this.requestURI = this.getContextPath() + servletPath;
        }
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        String sessionId = this.getCookieValue("jsessionId");
        if (sessionId != null) {
            this.session = new MockHttpSession(sessionId, this.getServletContext());
            this.session.setMaxInactiveInterval(3600);
        } else if (create) {
            sessionId = UUID.randomUUID().toString().replace("-", "");
            this.session = new MockHttpSession(sessionId, this.getServletContext());
            this.session.setMaxInactiveInterval(3600);
            this.setCookie("jsessionId", sessionId, -1);
        }
        return this.session;
    }

    public String changeSessionId() {
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        this.session = new MockHttpSession(sessionId, this.getServletContext());
        this.session.setMaxInactiveInterval(3600);
        this.setCookie("jsessionId", sessionId, -1);
        return sessionId;
    }

    private String getCookieValue(String name) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : null;
    }

    private Cookie getCookieObject(String name) {
        for (Cookie cookie : this.cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    private void setCookie(String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        this.response.addCookie(cookie);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        String cl = this.getHeader("content-length");
        if (cl != null) {
            try {
                return Integer.parseInt(cl);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        if (this.inputStream != null) {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return 0;
            }
        }
        return 0;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new MockServletInputStream("");
        }
        return this.inputStream;
    }

    public void setInputStream(ServletInputStream ins) {
        this.inputStream = ins;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public long getContentLengthLong() {
        return this.content != null ? this.content.length : -1;
    }

    public String getParameter(String key) {
        if (this.parameters.containsKey(key)) {
            return this.parameters.get(key)[0];
        }
        return null;
    }

    public void addParameter(String key, Number num) {
        this.addParameter(key, num.toString());
    }

    public void addParameter(String key, String value) {
        this.addParameter(key, new String[]{value});
    }

    public void addParameter(String key, Object value) {
        this.addParameter(key, new String[]{String.valueOf(value)});
    }

    public void addParameter(String key, String[] values) {
        this.parameters.put(key, values);
        if ("GET".equalsIgnoreCase(this.getMethod())) {
            this.updateQueryString();
        }
    }

    public void addQueryParameter(String key, Object value) {
        if ("GET".equalsIgnoreCase(this.getMethod())) {
            this.parameters.put(key, new String[]{String.valueOf(value)});
        }
        Map<Object, Object> queryStringMap = StrUtil.isNotBlank(this.queryString) ? StrUtil.queryStringToMap(this.queryString) : new HashMap();
        queryStringMap.put(key, value);
        this.setQueryString(StrUtil.mapToQueryString(queryStringMap));
    }

    private void updateQueryString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.parameters.keySet()) {
            if (key == null || key.length() == 0) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key.trim()).append("=");
            String[] values = this.parameters.get(key);
            if (values == null || values.length == 0) continue;
            if (values.length == 1) {
                sb.append(StrUtil.urlEncode(values[0]));
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                if (i == 0) {
                    sb.append(StrUtil.urlEncode(values[i]));
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(key.trim()).append("=").append(StrUtil.urlEncode(values[i]));
            }
        }
        this.setQueryString(sb.toString());
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void removeAttribute(String key) {
        this.attributeMap.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void setCookies(Set<Cookie> cookies) {
        this.cookies = cookies;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public void setLocales(LinkedList<Locale> locales) {
        this.locales = locales;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 80;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.requestedSessionIdFromURL;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
        LogKit.error((String)"Unsupport login method!");
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public String getScheme() {
        return "http";
    }

    public Locale getLocale() {
        return this.locales.getFirst();
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public long getDateHeader(String name) {
        return Long.valueOf(this.getHeader(name));
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public Enumeration<String> getHeaders(String name) {
        String header = this.getHeader(name);
        String[] headers = header.split(";");
        return Collections.enumeration(Arrays.asList(headers));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        return Integer.valueOf(this.getHeader(name));
    }

    public void logout() throws ServletException {
        this.userPrincipal = null;
        this.remoteUser = null;
        this.authType = null;
    }

    public void addPart(Part part) {
        this.parts.put((Object)part.getName(), (Object)part);
    }

    public Part getPart(String name) throws IOException, ServletException {
        Collection parts = this.parts.get((Object)name);
        Iterator iterator = parts.iterator();
        if (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            return part;
        }
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LinkedList<Part> result = new LinkedList<Part>(this.parts.values());
        return result;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        LogKit.error((String)"Unsupport upgrade method!");
        return null;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
}

