/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jboot.test.MockMvcAsserter;
import io.jboot.test.MockMvcJsonAsserter;
import io.jboot.test.MockMvcTrueAsserter;
import io.jboot.test.web.MockHttpServletResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.Cookie;

public class MockMvcResult {
    final MockHttpServletResponse response;
    private JSONObject jsonObject;

    public MockMvcResult(MockHttpServletResponse response) {
        this.response = response;
    }

    public String getContent() {
        return this.response.getContentString();
    }

    public JSONObject getContentAsJSONObject() {
        if (this.jsonObject == null) {
            this.jsonObject = JSON.parseObject((String)this.getContent());
        }
        return this.jsonObject;
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getHeader(String name) {
        return this.response.getHeader(name);
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Collection<String> headerNames = this.response.getHeaderNames();
        if (headerNames != null) {
            for (String headerName : headerNames) {
                headers.put(headerName, this.response.getHeader(headerName));
            }
        }
        return headers;
    }

    public Set<Cookie> getCookies() {
        return this.response.getCookies();
    }

    public String getCookie(String name) {
        for (Cookie cookie : this.response.getCookies()) {
            if (!Objects.equals(name, cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    public MockMvcResult printResult() {
        System.out.println(this);
        return this;
    }

    public MockMvcResult printContent() {
        System.out.println(this.getContent());
        return this;
    }

    public MockMvcResult assertThat(MockMvcAsserter mockMvcAssert) {
        mockMvcAssert.doAssert(this);
        return this;
    }

    public MockMvcResult assertJson(MockMvcJsonAsserter mockMvcAssert) {
        mockMvcAssert.doAssert(this.getContentAsJSONObject());
        return this;
    }

    public MockMvcResult assertTrue(MockMvcTrueAsserter mockMvcTrueAsserter) {
        return this.assertTrue(mockMvcTrueAsserter, "MockMvc result can not match the asserter.");
    }

    public MockMvcResult assertTrue(MockMvcTrueAsserter mockMvcTrueAsserter, String message) {
        if (!mockMvcTrueAsserter.doAssert(this)) {
            throw new AssertionError((Object)message);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Response:\n");
        builder.append("Headers >>> ").append(this.getHeaders()).append("\n");
        builder.append("Status  >>> ").append(this.getStatus()).append("\n");
        builder.append("Content >>> ").append(this.getContent()).append("\n");
        return builder.toString();
    }
}

