/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test;

import io.jboot.components.http.HttpMimeTypes;
import io.jboot.test.MockApp;
import io.jboot.test.MockMvcResult;
import io.jboot.test.web.MockHttpServletRequest;
import io.jboot.test.web.MockHttpServletResponse;
import io.jboot.test.web.MockServletInputStream;
import io.jboot.utils.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;

public class MockMvc {
    protected boolean holdCookiesEnable = false;
    protected Set<Cookie> holdCookies = new HashSet<Cookie>();
    protected Consumer<MockHttpServletRequest> requestStartListener;
    protected Consumer<MockHttpServletResponse> requestFinishedListener;

    public MockMvc() {
    }

    public MockMvc(boolean holdCookiesEnable) {
        this.holdCookiesEnable = holdCookiesEnable;
    }

    public boolean isHoldCookiesEnable() {
        return this.holdCookiesEnable;
    }

    public void setHoldCookiesEnable(boolean holdCookiesEnable) {
        this.holdCookiesEnable = holdCookiesEnable;
    }

    public Set<Cookie> getHoldCookies() {
        return this.holdCookies;
    }

    public String getCookieValue(String name) {
        for (Cookie holdCookie : this.holdCookies) {
            if (!holdCookie.getName().equals(name)) continue;
            return holdCookie.getValue();
        }
        return null;
    }

    public void setHoldCookies(Set<Cookie> holdCookies) {
        this.holdCookies = holdCookies;
    }

    public Consumer<MockHttpServletRequest> getRequestStartListener() {
        return this.requestStartListener;
    }

    public void setRequestStartListener(Consumer<MockHttpServletRequest> requestStartListener) {
        this.requestStartListener = requestStartListener;
    }

    public Consumer<MockHttpServletResponse> getRequestFinishedListener() {
        return this.requestFinishedListener;
    }

    public void setRequestFinishedListener(Consumer<MockHttpServletResponse> requestFinishedListener) {
        this.requestFinishedListener = requestFinishedListener;
    }

    public MockMvcResult get(String target) {
        return this.get(target, null, null, null);
    }

    public MockMvcResult get(String target, Map<String, Object> paras) {
        return this.get(target, paras, null, null);
    }

    public MockMvcResult get(String target, Map<String, Object> p, Set<Cookie> cookies) {
        return this.get(target, p, null, cookies);
    }

    public MockMvcResult get(String target, Map<String, Object> p, Map<String, String> headers) {
        return this.get(target, p, headers, null);
    }

    public MockMvcResult get(String target, Map<String, Object> p, Map<String, String> headers, Set<Cookie> cookies) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("GET");
        HashMap<String, Object> paras = p != null ? p : new HashMap<String, Object>();
        int indexOf = target.lastIndexOf("?");
        if (indexOf != -1) {
            Map<String, String> targetParas = StrUtil.queryStringToMap(target.substring(indexOf + 1));
            paras.putAll(targetParas);
            target = target.substring(0, indexOf);
        }
        request.setServletPath(target);
        if (headers != null) {
            request.setHeaders(headers);
        }
        paras.forEach(request::addParameter);
        if (cookies != null) {
            request.setCookies(cookies);
        }
        return this.doMockRequest(request);
    }

    public MockMvcResult post(String target) {
        return this.post(target, null, null, null, null);
    }

    public MockMvcResult post(String target, String postData) {
        return this.post(target, null, null, null, postData);
    }

    public MockMvcResult post(String target, Map<String, Object> paras) {
        return this.post(target, paras, null, null, null);
    }

    public MockMvcResult post(String target, Map<String, Object> paras, String postData) {
        return this.post(target, paras, null, null, postData);
    }

    public MockMvcResult post(String target, Map<String, Object> paras, Map<String, String> headers) {
        return this.post(target, paras, headers, null, null);
    }

    public MockMvcResult post(String target, Map<String, Object> paras, Map<String, String> headers, String postData) {
        return this.post(target, paras, headers, null, postData);
    }

    public MockMvcResult post(String target, Map<String, Object> paras, Map<String, String> headers, Set<Cookie> cookies, String postData) {
        MockServletInputStream inStream = null;
        if (StrUtil.isNotBlank(postData)) {
            inStream = new MockServletInputStream(postData);
        }
        return this.doPost(target, paras, headers, cookies, inStream);
    }

    public MockMvcResult upload(String target, Map<String, Object> paras, Map<String, String> headers, Set<Cookie> cookies) {
        String endFlag = "\r\n";
        String startFlag = "--";
        String boundary = "------" + StrUtil.uuid();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "multipart/form-data; boundary=" + boundary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (paras != null) {
            paras.forEach((key, value) -> {
                if (value instanceof File) {
                    File file = (File)value;
                    this.writeString(baos, startFlag + boundary + endFlag);
                    this.writeString(baos, "Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + file.getName() + "\"");
                    this.writeString(baos, endFlag + "Content-Type: " + HttpMimeTypes.getMimeType(file.getName()));
                    this.writeString(baos, endFlag + endFlag);
                    this.writeFile(baos, file);
                    this.writeString(baos, endFlag);
                } else {
                    this.writeString(baos, startFlag + boundary + endFlag);
                    this.writeString(baos, "Content-Disposition: form-data; name=\"" + key + "\"");
                    this.writeString(baos, endFlag + endFlag);
                    this.writeString(baos, String.valueOf(value));
                    this.writeString(baos, endFlag);
                }
            });
        }
        this.writeString(baos, startFlag + boundary + startFlag + endFlag);
        return this.doPost(target, paras, headers, cookies, new MockServletInputStream(baos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(ByteArrayOutputStream dos, File file) {
        FileInputStream fStream = null;
        try {
            fStream = new FileInputStream(file);
            byte[] buffer = new byte[2028];
            int len = 0;
            while ((len = fStream.read(buffer)) > 0) {
                dos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fStream != null) {
                try {
                    fStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeString(OutputStream dos, String s) {
        try {
            dos.write(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MockMvcResult doPost(String target, Map<String, Object> paras, Map<String, String> headers, Set<Cookie> cookies, ServletInputStream inStream) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("POST");
        int indexOf = target.lastIndexOf("?");
        if (indexOf != -1) {
            Map<String, String> targetParas = StrUtil.queryStringToMap(target.substring(indexOf + 1));
            if (paras == null) {
                paras = new HashMap<String, Object>();
            }
            paras.putAll(targetParas);
            target = target.substring(0, indexOf);
        }
        request.setServletPath(target);
        if (headers != null) {
            request.setHeaders(headers);
        }
        if (paras != null) {
            paras.forEach(request::addParameter);
        }
        if (inStream != null) {
            request.setInputStream(inStream);
        }
        if (cookies != null) {
            request.setCookies(cookies);
        }
        return this.doMockRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockMvcResult doMockRequest(MockHttpServletRequest request) {
        MockHttpServletResponse response = new MockHttpServletResponse();
        try {
            if (this.requestStartListener != null) {
                this.requestStartListener.accept(request);
            }
            HashSet<Cookie> cookies = new HashSet<Cookie>();
            if (this.isHoldCookiesEnable()) {
                cookies.addAll(this.holdCookies);
            }
            for (Cookie cookie2 : request.getCookies()) {
                this.doSetCookie(cookie2, cookies);
            }
            request.setCookies(cookies);
            this.doSendRequest(request, response);
        }
        finally {
            if (this.requestFinishedListener != null) {
                this.requestFinishedListener.accept(response);
            }
            if (this.isHoldCookiesEnable() && response.getCookies().size() > 0) {
                response.getCookies().forEach(cookie -> this.doSetCookie((Cookie)cookie, this.holdCookies));
            }
        }
        return new MockMvcResult(response);
    }

    public void doSetCookie(Cookie newCookie, Set<Cookie> toCookies) {
        toCookies.removeIf(cookie -> Objects.equals(cookie.getName(), newCookie.getName()));
        if (StrUtil.isNotEmpty(newCookie.getValue())) {
            toCookies.add(newCookie);
        }
    }

    public void doSendRequest(MockHttpServletRequest request, MockHttpServletResponse response) {
        MockApp.mockRequest((ServletRequest)request, (ServletResponse)response);
    }
}

