/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test;

import com.jfinal.kit.LogKit;
import io.jboot.aop.InterceptorCache;
import io.jboot.aop.cglib.JbootCglibCallback;
import io.jboot.aop.javassist.JbootJavassistHandler;
import io.jboot.service.JbootServiceBase;
import io.jboot.test.MockMethodInfo;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import net.sf.cglib.proxy.MethodProxy;

class MockMethodInterceptor
extends JbootCglibCallback
implements MethodHandler {
    private static final Map<InterceptorCache.MethodKey, MockMethodInfo> METHOD_INFO_CACHE = new HashMap<InterceptorCache.MethodKey, MockMethodInfo>();
    private boolean autoMockInterface;
    private static final JbootJavassistHandler orginalHandler = new JbootJavassistHandler();

    public static void addMethodInfo(MockMethodInfo value) {
        InterceptorCache.MethodKey methodKey = InterceptorCache.getMethodKey(value.getTargetClass(), value.getTargetMethod());
        METHOD_INFO_CACHE.put(methodKey, value);
    }

    public static void addMockClass(Class<?> mockClass) {
        Class<?>[] interfaces = mockClass.getInterfaces();
        ArrayList<MockMethodInfo> mockMethodInfos = new ArrayList<MockMethodInfo>();
        for (Class<?> inter : interfaces) {
            for (MockMethodInfo mockMethodInfo : METHOD_INFO_CACHE.values()) {
                if (mockMethodInfo.getTargetClass() != inter) continue;
                mockMethodInfos.add(new MockMethodInfo(mockMethodInfo, mockClass));
            }
        }
        mockMethodInfos.forEach(MockMethodInterceptor::addMethodInfo);
    }

    public MockMethodInterceptor(boolean autoMockInterface) {
        this.autoMockInterface = autoMockInterface;
    }

    @Override
    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        InterceptorCache.MethodKey methodKey;
        Class<?> targetClass = ClassUtil.getUsefulClass(target.getClass());
        if (targetClass == Object.class && method.getDeclaringClass() != Object.class) {
            targetClass = method.getDeclaringClass();
        }
        if (METHOD_INFO_CACHE.containsKey(methodKey = InterceptorCache.getMethodKey(targetClass, method))) {
            MockMethodInfo methodInfo = METHOD_INFO_CACHE.get(methodKey);
            return methodInfo.invokeMock(target, args);
        }
        if (this.autoMockInterface && Modifier.isInterface(targetClass.getModifiers())) {
            if (!"toString".equals(method.getName()) || args.length != 0) {
                LogKit.warn((String)("Return null for Mock Method: \"" + ClassUtil.buildMethodString(method) + "\", Because the class \"" + targetClass.getName() + "\" is an interface and has no any implementation classes."));
            }
            return null;
        }
        try {
            return super.intercept(target, method, args, methodProxy);
        }
        catch (Exception ex) {
            if ("initDao".equals(method.getName()) && JbootServiceBase.class == method.getDeclaringClass()) {
                return null;
            }
            throw ex;
        }
    }

    public Object invoke(Object target, Method thisMethod, Method method, Object[] args) throws Throwable {
        InterceptorCache.MethodKey methodKey;
        Class<?> targetClass = ClassUtil.getUsefulClass(target.getClass());
        if (targetClass == Object.class && method.getDeclaringClass() != Object.class) {
            targetClass = method.getDeclaringClass();
        }
        if (METHOD_INFO_CACHE.containsKey(methodKey = InterceptorCache.getMethodKey(targetClass, method))) {
            MockMethodInfo methodInfo = METHOD_INFO_CACHE.get(methodKey);
            return methodInfo.invokeMock(target, args);
        }
        if (this.autoMockInterface && Modifier.isInterface(targetClass.getModifiers())) {
            if (!"toString".equals(method.getName()) || args.length != 0) {
                LogKit.warn((String)("Return null for Mock Method: \"" + ClassUtil.buildMethodString(method) + "\", Because the class \"" + targetClass.getName() + "\" is an interface and has no any implementation classes."));
            }
            return null;
        }
        try {
            return orginalHandler.invoke(target, thisMethod, method, args);
        }
        catch (Exception ex) {
            if ("initDao".equals(method.getName()) && JbootServiceBase.class == method.getDeclaringClass()) {
                return null;
            }
            throw ex;
        }
    }
}

