/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test;

import com.jfinal.kit.LogKit;
import io.jboot.test.MockApp;
import io.jboot.test.MockMethod;
import io.jboot.utils.ReflectUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

class MockMethodInfo {
    private Class<?> targetClass;
    private Method targetMethod;
    private boolean firstArgIsTarget;
    private Class<?> mockClass;
    private Method mockMethod;

    public MockMethodInfo(MockMethodInfo methodInfo, Class<?> newTargetClass) {
        this.targetClass = newTargetClass;
        this.targetMethod = methodInfo.targetMethod;
        this.firstArgIsTarget = methodInfo.firstArgIsTarget;
        this.mockClass = methodInfo.mockClass;
        this.mockMethod = methodInfo.mockMethod;
    }

    public MockMethodInfo(Class<?> testClass, Method testClassMethod, MockMethod mockMethod) {
        this.targetClass = mockMethod.targetClass();
        String targetMethodName = StrUtil.isNotBlank(mockMethod.targetMethod()) ? mockMethod.targetMethod() : testClassMethod.getName();
        this.targetMethod = ReflectUtil.searchMethod(this.targetClass, m -> {
            if (!m.getName().equals(targetMethodName)) {
                return false;
            }
            Object[] testClassMethodParaTypes = testClassMethod.getParameterTypes();
            if (Arrays.equals(m.getParameterTypes(), testClassMethodParaTypes)) {
                return true;
            }
            if (testClassMethodParaTypes.length > 0 && testClassMethodParaTypes[0] == mockMethod.targetClass()) {
                Object[] newClassMethodParaTypes = new Class[testClassMethodParaTypes.length - 1];
                System.arraycopy(testClassMethodParaTypes, 1, newClassMethodParaTypes, 0, newClassMethodParaTypes.length);
                if (Arrays.equals(m.getParameterTypes(), newClassMethodParaTypes)) {
                    this.firstArgIsTarget = true;
                    return true;
                }
            }
            return false;
        });
        if (this.targetMethod == null) {
            throw new IllegalStateException("Can not mock the method: \"" + targetMethodName + "\" in class: " + mockMethod.targetClass());
        }
        this.mockClass = testClass;
        this.mockMethod = testClassMethod;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Class<?> getMockClass() {
        return this.mockClass;
    }

    public void setMockClass(Class<?> mockClass) {
        this.mockClass = mockClass;
    }

    public Method getMockMethod() {
        return this.mockMethod;
    }

    public void setMockMethod(Method mockMethod) {
        this.mockMethod = mockMethod;
    }

    public Object invokeMock(Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        Object testInstance;
        if (this.firstArgIsTarget) {
            Object[] newArgs = new Object[args.length + 1];
            newArgs[0] = obj;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            args = newArgs;
        }
        if ((testInstance = MockApp.getInstance().getTestInstance()) == null) {
            testInstance = MockMethodInfo.newInstance(this.mockClass);
        }
        if (testInstance == null) {
            return null;
        }
        return this.mockMethod.invoke(testInstance, args);
    }

    private static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogKit.logNothing((Throwable)e);
            return null;
        }
    }
}

