/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.test;

import com.jfinal.config.JFinalConfig;
import com.jfinal.core.JFinalFilter;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import io.jboot.aop.JbootAopFactory;
import io.jboot.aop.cglib.JbootCglibProxyFactory;
import io.jboot.aop.javassist.JbootJavassistProxyFactory;
import io.jboot.app.PathKitExt;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.test.MockClass;
import io.jboot.test.MockClassInfo;
import io.jboot.test.MockMethod;
import io.jboot.test.MockMethodInfo;
import io.jboot.test.MockMethodInterceptor;
import io.jboot.test.TestConfig;
import io.jboot.test.web.MockFilterChain;
import io.jboot.test.web.MockFilterConfig;
import io.jboot.test.web.MockJFinalFilter;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.FileUtil;
import io.jboot.utils.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class MockApp {
    public static final String DEFAULT_WEB_ROOT_PATH = "../classes/webapp";
    public static final String DEFAULT_CLASS_PATH = "../classes";
    private static final MockApp app = new MockApp();
    private JFinalConfig config;
    private final JFinalFilter filter = new MockJFinalFilter();
    private Object testInstance;
    private boolean isInit = false;

    private MockApp() {
    }

    public static MockApp getInstance() {
        return app;
    }

    static void mockRequest(ServletRequest req, ServletResponse res) {
        try {
            MockApp.app.filter.doFilter(req, res, (FilterChain)new MockFilterChain());
        }
        catch (IOException | ServletException e) {
            e.printStackTrace();
        }
    }

    public void setTestInstance(Object testInstance) {
        this.testInstance = testInstance;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    void start(Class<?> testClass) {
        if (!this.isInit) {
            this.init(testClass);
            this.isInit = true;
        }
    }

    private void init(Class<?> testClass) {
        try {
            List<MockClassInfo> mockClassInfos;
            TestConfig testConfig = testClass.getAnnotation(TestConfig.class);
            if (testConfig != null) {
                JbootConfigManager.parseArgs(testConfig.launchArgs());
                JbootConfigManager.me().setDevMode(testConfig.devMode());
                ClassScanner.setPrintScannerInfoEnable(testConfig.printScannerInfo());
            } else {
                ClassScanner.setPrintScannerInfoEnable(false);
            }
            this.doInitJFinalPathKit(testConfig);
            boolean autoMockInterface = testConfig != null && testConfig.autoMockInterface();
            JbootCglibProxyFactory.setMethodInterceptor(aClass -> new MockMethodInterceptor(autoMockInterface));
            JbootJavassistProxyFactory.setMethodInterceptor(aClass -> new MockMethodInterceptor(autoMockInterface));
            List<MockMethodInfo> mockMethodInfos = this.getMockMethodInfoList(testClass);
            if (!mockMethodInfos.isEmpty()) {
                mockMethodInfos.forEach(MockMethodInterceptor::addMethodInfo);
            }
            if ((mockClassInfos = this.getMockClassInfoList(testClass)) != null && !mockClassInfos.isEmpty()) {
                mockClassInfos.forEach(mockClassInfo -> {
                    JbootAopFactory.me().addMapping(mockClassInfo.getTargetClass(), mockClassInfo.getMockClass());
                    MockMethodInterceptor.addMockClass(mockClassInfo.getMockClass());
                });
            }
            this.filter.init((FilterConfig)new MockFilterConfig());
            this.config = (JFinalConfig)ReflectUtil.getFieldValue(this.filter, "jfinalConfig");
        }
        catch (ServletException e) {
            LogKit.error((String)e.toString(), (Throwable)e);
        }
    }

    private List<MockClassInfo> getMockClassInfoList(Class<?> testClass) {
        List<Class> scanedClasses = ClassScanner.scanClassByAnnotation(MockClass.class, true);
        LinkedList<Class> mockClasses = new LinkedList<Class>(scanedClasses);
        Class<?>[] declardClasses = testClass.getDeclaredClasses();
        if (declardClasses.length > 0) {
            for (Class<?> declardClass : declardClasses) {
                if (declardClass.getAnnotation(MockClass.class) == null) continue;
                mockClasses.remove(declardClass);
                mockClasses.addLast(declardClass);
            }
        }
        if (mockClasses.isEmpty()) {
            return null;
        }
        ArrayList<MockClassInfo> classInfoList = new ArrayList<MockClassInfo>();
        for (Class mockClass : mockClasses) {
            Class<?>[] targetClasses = mockClass.getInterfaces();
            if (targetClasses.length == 0) {
                throw new IllegalStateException("@MockClass() in \"" + mockClass.getName() + "\" must implementation interface.");
            }
            for (Class<?> targetClass : targetClasses) {
                classInfoList.add(new MockClassInfo(mockClass, targetClass));
            }
        }
        return classInfoList;
    }

    private List<MockMethodInfo> getMockMethodInfoList(Class<?> testClass) {
        ArrayList<MockMethodInfo> methodInfoList = new ArrayList<MockMethodInfo>();
        this.searchMockMethods(testClass, methodInfoList);
        return methodInfoList;
    }

    private void searchMockMethods(Class<?> searchClass, List<MockMethodInfo> tolist) {
        Method[] methods;
        for (Method method : methods = searchClass.getDeclaredMethods()) {
            MockMethod mockMethod = method.getAnnotation(MockMethod.class);
            if (mockMethod == null) continue;
            tolist.add(new MockMethodInfo(searchClass, method, mockMethod));
        }
        Class<?> superClass = searchClass.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.searchMockMethods(superClass, tolist);
        }
    }

    void stop() {
        if (this.config != null) {
            this.config.onStop();
        }
    }

    private void doInitJFinalPathKit(TestConfig testConfig) {
        try {
            String configClassPath;
            String configWebRootPath = testConfig != null ? testConfig.webRootPath() : DEFAULT_WEB_ROOT_PATH;
            String string = configClassPath = testConfig != null ? testConfig.classPath() : DEFAULT_CLASS_PATH;
            if (!FileUtil.isAbsolutePath(configWebRootPath)) {
                configWebRootPath = new File(PathKitExt.getWebRootPath(), configWebRootPath).getCanonicalPath();
            }
            PathKit.setWebRootPath((String)configWebRootPath);
            if (!FileUtil.isAbsolutePath(configClassPath)) {
                configClassPath = new File(PathKitExt.getRootClassPath(), configClassPath).getCanonicalPath();
            }
            PathKit.setRootClassPath((String)configClassPath);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

