/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.swagger;

import com.jfinal.core.ActionKey;
import io.jboot.support.swagger.ControllerReaderExtension;
import io.jboot.support.swagger.ReaderContext;
import io.jboot.support.swagger.SwaggerPath;
import io.jboot.web.controller.JbootControllerManager;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;

public class Reader {
    private final Swagger swagger;

    private Reader(Swagger swagger) {
        this.swagger = swagger;
    }

    public static void read(Swagger swagger, List<Class> classes) {
        Reader reader = new Reader(swagger);
        for (Class cls : classes) {
            ReaderContext context = new ReaderContext(cls, "", null, false);
            reader.read(context);
        }
    }

    private void read(ReaderContext context) {
        for (Method method : context.getCls().getDeclaredMethods()) {
            HashMap regexMap;
            String parsedPath;
            Path path;
            if (ReflectionUtils.isOverriddenMethod((Method)method, context.getCls())) continue;
            Operation operation = new Operation();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            ControllerReaderExtension extension = new ControllerReaderExtension();
            String methodPath = "index".equals(method.getName()) ? "" : "/" + method.getName();
            String operationPath = JbootControllerManager.me().getPathByController(context.getCls()) + methodPath;
            ActionKey actionKeyAnnotation = (ActionKey)ReflectionUtils.getAnnotation((Method)method, ActionKey.class);
            if (actionKeyAnnotation != null && !actionKeyAnnotation.value().isEmpty()) {
                operationPath = actionKeyAnnotation.value();
            }
            String httpMethod = extension.getHttpMethod(context, method);
            if (operationPath == null || httpMethod == null) continue;
            if (extension.isReadable(context)) {
                extension.setDeprecated(operation, method);
                extension.applyConsumes(context, operation, method);
                extension.applyProduces(context, operation, method);
                extension.applyOperationId(operation, method);
                extension.applySummary(operation, method);
                extension.applyDescription(operation, method);
                extension.applySchemes(context, operation, method);
                extension.applySecurityRequirements(context, operation, method);
                extension.applyTags(context, operation, method);
                extension.applyResponses(this.swagger, context, operation, method);
                extension.applyImplicitParameters(this.swagger, context, operation, method);
                extension.applyExtensions(context, operation, method);
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    extension.applyParameters(httpMethod, context, operation, paramAnnotations[i]);
                }
                if ("post".equalsIgnoreCase(httpMethod) && operation.getConsumes() == null) {
                    operation.addConsumes("application/x-www-form-urlencoded");
                }
            }
            if (operation.getResponses() == null) {
                operation.defaultResponse(new Response().description("successful operation"));
            }
            if ((path = this.swagger.getPath(parsedPath = PathUtils.parsePath((String)operationPath, regexMap = new HashMap()))) == null) {
                path = new SwaggerPath();
                this.swagger.path(parsedPath, path);
            }
            path.set(httpMethod.toLowerCase(), operation);
        }
    }
}

