/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.swagger;

import io.jboot.Jboot;
import io.jboot.support.swagger.JbootSwaggerConfig;
import io.jboot.support.swagger.Reader;
import io.jboot.utils.ClassScanner;
import io.jboot.web.controller.annotation.RequestMapping;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.List;

public class JbootSwaggerManager {
    private JbootSwaggerConfig config = Jboot.config(JbootSwaggerConfig.class);
    private Swagger swagger;
    private static JbootSwaggerManager instance;

    public static JbootSwaggerManager me() {
        if (instance == null) {
            instance = new JbootSwaggerManager();
        }
        return instance;
    }

    public void init() {
        if (!this.config.isConfigOk()) {
            return;
        }
        this.swagger = new Swagger();
        this.swagger.setHost(this.config.getHost());
        this.swagger.setBasePath("/");
        this.swagger.addScheme(Scheme.HTTP);
        this.swagger.addScheme(Scheme.HTTPS);
        Info swaggerInfo = new Info();
        swaggerInfo.setDescription(this.config.getDescription());
        swaggerInfo.setVersion(this.config.getVersion());
        swaggerInfo.setTitle(this.config.getTitle());
        swaggerInfo.setTermsOfService(this.config.getTermsOfService());
        Contact contact = new Contact();
        contact.setName(this.config.getContactName());
        contact.setEmail(this.config.getContactEmail());
        contact.setUrl(this.config.getContactUrl());
        swaggerInfo.setContact(contact);
        License license = new License();
        license.setName(this.config.getLicenseName());
        license.setUrl(this.config.getLicenseUrl());
        swaggerInfo.setLicense(license);
        this.swagger.setInfo(swaggerInfo);
        List<Class> classes = ClassScanner.scanClassByAnnotation(RequestMapping.class, false);
        Reader.read(this.swagger, classes);
    }

    public Swagger getSwagger() {
        return this.swagger;
    }
}

