/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.processer;

import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.support.shiro.processer.IShiroAuthorizeProcesser;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.subject.Subject;

public class ShiroRequiresPermissionsProcesser
implements IShiroAuthorizeProcesser {
    private final RequiresPermissions requiresPermissions;

    public ShiroRequiresPermissionsProcesser(RequiresPermissions requiresPermissions) {
        this.requiresPermissions = requiresPermissions;
    }

    @Override
    public AuthorizeResult authorize() {
        try {
            String[] perms = this.requiresPermissions.value();
            Subject subject = SecurityUtils.getSubject();
            if (perms.length == 1) {
                subject.checkPermission(perms[0]);
                return AuthorizeResult.ok();
            }
            if (Logical.AND.equals((Object)this.requiresPermissions.logical())) {
                subject.checkPermissions(perms);
                return AuthorizeResult.ok();
            }
            if (Logical.OR.equals((Object)this.requiresPermissions.logical())) {
                boolean hasAtLeastOnePermission = false;
                for (String permission : perms) {
                    if (!subject.isPermitted(permission)) continue;
                    hasAtLeastOnePermission = true;
                }
                if (!hasAtLeastOnePermission) {
                    subject.checkPermission(perms[0]);
                }
            }
            return AuthorizeResult.ok();
        }
        catch (AuthorizationException e) {
            return AuthorizeResult.fail(2);
        }
    }
}

