/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro;

import com.jfinal.aop.Invocation;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.template.expr.ast.MethodKeyBuilder;
import io.jboot.Jboot;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.shiro.JbootShiroConfig;
import io.jboot.support.shiro.JbootShiroInvokeListener;
import io.jboot.support.shiro.JbootShiroUtil;
import io.jboot.support.shiro.ShiroAuthorizeProcesserInvoker;
import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.support.shiro.processer.IShiroAuthorizeProcesser;
import io.jboot.support.shiro.processer.ShiroClear;
import io.jboot.support.shiro.processer.ShiroRequiresAuthenticationProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresGuestProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresPermissionsProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresRolesProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresUserProcesser;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

public class JbootShiroManager {
    private static final JbootShiroManager me = new JbootShiroManager();
    private final JbootShiroConfig jbootShiroConfig = Jboot.config(JbootShiroConfig.class);
    private final ShiroRequiresAuthenticationProcesser requiresAuthenticationProcessor = new ShiroRequiresAuthenticationProcesser();
    private final ShiroRequiresUserProcesser requiresUserProcessor = new ShiroRequiresUserProcesser();
    private final ShiroRequiresGuestProcesser requiresGuestProcessor = new ShiroRequiresGuestProcesser();
    private ConcurrentHashMap<Long, ShiroAuthorizeProcesserInvoker> invokers = new ConcurrentHashMap();
    private static MethodKeyBuilder keyBuilder = new MethodKeyBuilder.FastMethodKeyBuilder();
    private JbootShiroInvokeListener invokeListener;

    private JbootShiroManager() {
    }

    public static JbootShiroManager me() {
        return me;
    }

    public void init(List<Routes.Route> routes) {
    }

    public boolean buildShiroInvoker(Class clazz, Method method) {
        if (Controller.class.isAssignableFrom(clazz) && JbootShiroUtil.getControllerExcludedMethodName().contains(method.getName())) {
            return false;
        }
        if (method.getAnnotation(ShiroClear.class) != null) {
            return false;
        }
        Annotation[] allAnnotations = ArrayUtil.concat(clazz.getAnnotations(), new Annotation[][]{method.getAnnotations()});
        ShiroAuthorizeProcesserInvoker invoker = new ShiroAuthorizeProcesserInvoker();
        for (Annotation annotation : allAnnotations) {
            IShiroAuthorizeProcesser processor;
            if (annotation.annotationType() == RequiresPermissions.class) {
                processor = new ShiroRequiresPermissionsProcesser((RequiresPermissions)annotation);
                invoker.addProcesser(processor);
                continue;
            }
            if (annotation.annotationType() == RequiresRoles.class) {
                processor = new ShiroRequiresRolesProcesser((RequiresRoles)annotation);
                invoker.addProcesser(processor);
                continue;
            }
            if (annotation.annotationType() == RequiresUser.class) {
                invoker.addProcesser(this.requiresUserProcessor);
                continue;
            }
            if (annotation.annotationType() == RequiresAuthentication.class) {
                invoker.addProcesser(this.requiresAuthenticationProcessor);
                continue;
            }
            if (annotation.annotationType() != RequiresGuest.class) continue;
            invoker.addProcesser(this.requiresGuestProcessor);
        }
        if (invoker.getProcessers() != null && invoker.getProcessers().size() > 0) {
            this.invokers.put(JbootShiroManager.getMethodKey(method), invoker);
            return true;
        }
        return false;
    }

    public AuthorizeResult invoke(Invocation invocation) {
        ShiroAuthorizeProcesserInvoker invoker = this.invokers.get(JbootShiroManager.getMethodKey(invocation.getMethod()));
        if (invoker == null) {
            return AuthorizeResult.ok();
        }
        return invoker.invoke();
    }

    public static Long getMethodKey(Method method) {
        return keyBuilder.getMethodKey(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes());
    }

    public JbootShiroInvokeListener getInvokeListener() {
        if (this.invokeListener != null) {
            return this.invokeListener;
        }
        this.invokeListener = JbootShiroInvokeListener.DEFAULT;
        if (StrUtil.isNotBlank(this.jbootShiroConfig.getInvokeListener())) {
            this.invokeListener = (JbootShiroInvokeListener)ClassUtil.newInstance(this.jbootShiroConfig.getInvokeListener());
            if (this.invokeListener == null) {
                throw new JbootIllegalConfigException("can not find Class : " + this.jbootShiroConfig.getInvokeListener() + " please config jboot.shiro.invokeListener correct. ");
            }
        }
        return this.invokeListener;
    }
}

