/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro;

import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import io.jboot.Jboot;
import io.jboot.support.shiro.JbootShiroConfig;
import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.utils.StrUtil;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.util.WebUtils;

public interface JbootShiroInvokeListener {
    public static final JbootShiroInvokeListener DEFAULT = new JbootShiroInvokeListener(){
        private JbootShiroConfig config = Jboot.config(JbootShiroConfig.class);

        @Override
        public AuthorizeResult onInvokeBefore(Invocation inv) {
            return null;
        }

        @Override
        public void onInvokeAfter(Invocation inv, AuthorizeResult result) {
            if (result.isOk()) {
                inv.invoke();
                return;
            }
            int errorCode = result.getErrorCode();
            switch (errorCode) {
                case 1: {
                    this.doProcessUnauthenticated(inv.getController());
                    break;
                }
                case 2: {
                    this.doProcessuUnauthorization(inv.getController());
                    break;
                }
                default: {
                    inv.getController().renderError(404);
                }
            }
        }

        public void doProcessUnauthenticated(Controller controller) {
            if (StrUtil.isBlank((String)this.config.getLoginUrl())) {
                controller.renderError(401);
                return;
            }
            HttpServletRequest request = controller.getRequest();
            WebUtils.saveRequest((ServletRequest)request);
            controller.redirect(this.config.getLoginUrl());
        }

        public void doProcessuUnauthorization(Controller controller) {
            if (StrUtil.isBlank((String)this.config.getUnauthorizedUrl())) {
                controller.renderError(403);
                return;
            }
            controller.redirect(this.config.getUnauthorizedUrl());
        }
    };

    public AuthorizeResult onInvokeBefore(Invocation var1);

    public void onInvokeAfter(Invocation var1, AuthorizeResult var2);
}

