/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.redis.RedisDataSource;
import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.jboot.Jboot;
import io.jboot.support.sentinel.datasource.RedisDatasourceConfig;
import io.jboot.support.sentinel.datasource.SentinelDatasourceFactory;
import io.jboot.utils.StrUtil;
import java.util.List;

public class RedisDatasourceFactory
implements SentinelDatasourceFactory {
    @Override
    public ReadableDataSource createDataSource() {
        RedisDatasourceConfig rdc = Jboot.config(RedisDatasourceConfig.class);
        rdc.assertConfigOk();
        RedisConnectionConfig.Builder builder = RedisConnectionConfig.builder().withHost(rdc.getHost()).withPort(rdc.getPort()).withDatabase(rdc.getDatabase());
        if (StrUtil.isNotBlank(rdc.getPassword())) {
            builder.withPassword(rdc.getPassword());
        }
        return new RedisDataSource(builder.build(), rdc.getRuleKey(), rdc.getChannel(), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
    }
}

