/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.jfinal.kit.LogKit;
import io.jboot.utils.FileUtil;
import io.jboot.utils.QuietlyUtil;
import java.io.File;

public class FileDataSource<T>
extends AbstractDataSource<String, T> {
    private File file;
    private boolean fileExists;
    private long fileLastModified = -1L;
    private long fileLength = -1L;
    private boolean isClosed = false;

    public FileDataSource(File file, Converter<String, T> parser) {
        super(parser);
        this.file = file;
        this.fileExists = file.exists();
        if (this.fileExists) {
            this.fileLastModified = file.lastModified();
            this.fileLength = file.length();
        }
        this.updateProperties();
        new Thread(() -> {
            while (!this.isClosed) {
                try {
                    this.doReadAndUpdateProperties();
                }
                catch (Exception ex) {
                    LogKit.error((String)ex.toString(), (Throwable)ex);
                }
                QuietlyUtil.sleepQuietly(5000L);
            }
        }, "jboot-sentinel-file-reader").start();
    }

    private void doReadAndUpdateProperties() {
        long fileLength;
        boolean fileExists = this.file.exists();
        long fileLastModified = fileExists ? this.file.lastModified() : -1L;
        long l = fileLength = fileExists ? this.file.length() : -1L;
        if (this.fileExists != fileExists || this.fileLength != fileLength || this.fileLastModified != fileLastModified) {
            this.updateProperties();
            this.fileExists = fileExists;
            this.fileLastModified = fileLastModified;
            this.fileLength = fileLength;
        }
    }

    private void updateProperties() {
        String content = this.file.exists() ? FileUtil.readString(this.file) : "";
        this.getProperty().updateValue(this.parser.convert((Object)content));
    }

    public String readSource() throws Exception {
        return FileUtil.readString(this.file);
    }

    public void close() throws Exception {
        this.isClosed = true;
    }
}

