/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.LogKit;
import io.jboot.support.sentinel.SentinelConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SentinelUtil {
    private static final String PATH_SPLIT = "/";
    protected static final String contentType = "application/json; charset=utf-8";

    public static String buildResource(HttpServletRequest request) {
        String pathInfo = SentinelUtil.getResourcePath(request);
        if (!pathInfo.startsWith(PATH_SPLIT)) {
            pathInfo = PATH_SPLIT + pathInfo;
        }
        if (PATH_SPLIT.equals(pathInfo)) {
            return pathInfo;
        }
        int lastSlashIndex = pathInfo.lastIndexOf(PATH_SPLIT);
        pathInfo = lastSlashIndex >= 0 ? pathInfo.substring(0, lastSlashIndex) + PATH_SPLIT + StringUtil.trim((String)pathInfo.substring(lastSlashIndex + 1)) : PATH_SPLIT + StringUtil.trim((String)pathInfo);
        return pathInfo;
    }

    private static String getResourcePath(HttpServletRequest request) {
        String pathInfo = SentinelUtil.normalizeAbsolutePath(request.getPathInfo(), false);
        String servletPath = SentinelUtil.normalizeAbsolutePath(request.getServletPath(), pathInfo.length() != 0);
        return servletPath + pathInfo;
    }

    private static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalStateException {
        return SentinelUtil.normalizePath(path, true, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalStateException {
        char[] pathChars = StringUtil.trimToEmpty((String)path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == PATH_SPLIT.charAt(0) || firstChar == '\\';
            endsWithSlash = lastChar == PATH_SPLIT.charAt(0) || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append(PATH_SPLIT);
        }
        while (index < length && (index = SentinelUtil.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = SentinelUtil.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalStateException(path);
                    }
                    buf.append("..").append(PATH_SPLIT);
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append(PATH_SPLIT);
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == PATH_SPLIT.charAt(0) || ch == '\\' : ch != PATH_SPLIT.charAt(0) && ch != '\\') break;
        }
        return i;
    }

    public static void writeDefaultBlockedJson(HttpServletResponse resp, Map map) throws IOException {
        resp.setStatus(200);
        resp.setContentType(contentType);
        PrintWriter out = resp.getWriter();
        out.print(JsonKit.toJson((Object)map));
    }

    public static void writeDefaultBlockedPage(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        PrintWriter out = resp.getWriter();
        out.print("Blocked by Sentinel (flow limiting) in Jboot");
    }

    public static void blockRequest(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer url = request.getRequestURL();
        if ("GET".equals(request.getMethod()) && StringUtil.isNotBlank((String)request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        SentinelConfig config = SentinelConfig.get();
        try {
            if (StringUtil.isNotBlank((String)config.getRequestBlockPage())) {
                String redirectUrl = config.getRequestBlockPage() + "?http_referer=" + url.toString();
                response.sendRedirect(redirectUrl);
            } else if (config.getRequestBlockJsonMap() != null && !config.getRequestBlockJsonMap().isEmpty()) {
                SentinelUtil.writeDefaultBlockedJson(response, config.getRequestBlockJsonMap());
            } else {
                SentinelUtil.writeDefaultBlockedPage(response);
            }
        }
        catch (IOException ex) {
            LogKit.error((String)ex.toString(), (Throwable)ex);
        }
    }
}

