/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.support.sentinel.SentinelConfig;
import io.jboot.support.sentinel.SentinelInterceptor;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Method;

@AutoLoad
public class SentinelInterceptorBuilder
implements InterceptorBuilder {
    private static Boolean hasSentinelDependency = ClassUtil.hasClass("com.alibaba.csp.sentinel.Sph");
    private static Boolean isEnable = SentinelConfig.get().isEnable();

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (hasSentinelDependency.booleanValue() && isEnable.booleanValue() && InterceptorBuilder.Util.hasAnnotation(method, SentinelResource.class)) {
            interceptors.add(SentinelInterceptor.class);
        }
    }
}

