/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.jfinal.handler.Handler;
import io.jboot.support.sentinel.SentinelConfig;
import io.jboot.support.sentinel.SentinelUtil;
import io.jboot.utils.StrUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SentinelHandler
extends Handler {
    private static final String EMPTY_ORIGIN = "";
    private final String[] targetPrefix = this.parseTargetPrefix();

    private String[] parseTargetPrefix() {
        String reqeustTargetPrefix = SentinelConfig.get().getReqeustTargetPrefix();
        if (StrUtil.isBlank((String)reqeustTargetPrefix)) {
            return new String[0];
        }
        return StrUtil.splitToSet(reqeustTargetPrefix, ",").toArray(new String[0]);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.contains(".")) {
            this.next.handle(target, request, response, isHandled);
            return;
        }
        if (this.targetPrefix.length > 0) {
            boolean matchTarget = false;
            for (String prefx : this.targetPrefix) {
                if (!target.startsWith(prefx)) continue;
                matchTarget = true;
                break;
            }
            if (!matchTarget) {
                this.next.handle(target, request, response, isHandled);
                return;
            }
        }
        Entry urlEntry = null;
        try {
            String targetResource = SentinelUtil.buildResource(request);
            if (StrUtil.isNotBlank(targetResource)) {
                ContextUtil.enter((String)targetResource, (String)this.getOrigin(request));
                urlEntry = SphU.entry((String)targetResource, (int)1, (EntryType)EntryType.IN);
            }
            this.next.handle(target, request, response, isHandled);
        }
        catch (BlockException e) {
            SentinelUtil.blockRequest(request, response);
            isHandled[0] = true;
        }
        catch (Exception e2) {
            Tracer.traceEntry((Throwable)e2, urlEntry);
            throw e2;
        }
        finally {
            if (urlEntry != null) {
                urlEntry.exit();
            }
            ContextUtil.exit();
        }
    }

    protected String getOrigin(HttpServletRequest request) {
        return EMPTY_ORIGIN;
    }
}

