/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.datasource.FileWritableDataSource;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jfinal.kit.PathKit;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.support.sentinel.SentinelConfig;
import io.jboot.support.sentinel.datasource.ApolloDatasourceFactory;
import io.jboot.support.sentinel.datasource.FileDataSource;
import io.jboot.support.sentinel.datasource.NacosDatasourceFactory;
import io.jboot.support.sentinel.datasource.RedisDatasourceFactory;
import io.jboot.support.sentinel.datasource.SentinelDatasourceFactory;
import io.jboot.support.sentinel.datasource.ZookeeperDatasourceFactory;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.util.List;

public class JbootSentinelBuilder {
    public void init() {
        SentinelConfig config = SentinelConfig.get();
        if (StrUtil.isNotBlank(config.getDatasource())) {
            SentinelDatasourceFactory factory = this.getDatasourceFactory(config);
            ReadableDataSource rds = factory.createDataSource();
            FlowRuleManager.register2Property((SentinelProperty)rds.getProperty());
        } else {
            String rulePath = config.getRuleFile();
            File ruleFile = rulePath.startsWith("/") ? new File(rulePath) : new File(PathKit.getWebRootPath(), rulePath);
            FileDataSource rds = new FileDataSource(ruleFile, this::decodeJson);
            FlowRuleManager.register2Property((SentinelProperty)rds.getProperty());
            FileWritableDataSource wds = new FileWritableDataSource(ruleFile, this::encodeJson);
            WritableDataSourceRegistry.registerFlowDataSource((WritableDataSource)wds);
        }
    }

    private <T> String encodeJson(T t) {
        return JSON.toJSONString(t);
    }

    private List<FlowRule> decodeJson(String source) {
        return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]);
    }

    private SentinelDatasourceFactory getDatasourceFactory(SentinelConfig config) {
        String datasource;
        switch (datasource = config.getDatasource()) {
            case "apollo": {
                return new ApolloDatasourceFactory();
            }
            case "nacos": {
                return new NacosDatasourceFactory();
            }
            case "zookeeper": {
                return new ZookeeperDatasourceFactory();
            }
            case "redis": {
                return new RedisDatasourceFactory();
            }
        }
        SentinelDatasourceFactory dataSourceFactory = JbootSpiLoader.load(SentinelDatasourceFactory.class, datasource);
        if (dataSourceFactory == null) {
            throw new NullPointerException("Can not load SentinelDatasourceFactory spi for name: " + datasource);
        }
        return dataSourceFactory;
    }
}

