/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.jfinal.aop.Invocation;
import io.jboot.support.sentinel.MethodWrapper;
import io.jboot.support.sentinel.ResourceMetadataRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public abstract class AbstractSentinelInterceptor {
    protected void traceException(Throwable ex) {
        Tracer.trace((Throwable)ex);
    }

    protected void traceException(Throwable ex, SentinelResource annotation) {
        Class[] exceptionsToIgnore = annotation.exceptionsToIgnore();
        if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
            return;
        }
        if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
            this.traceException(ex);
        }
    }

    protected boolean exceptionBelongsTo(Throwable ex, Class<? extends Throwable>[] exceptions) {
        if (exceptions == null) {
            return false;
        }
        for (Class<? extends Throwable> exceptionClass : exceptions) {
            if (!exceptionClass.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    protected String getResourceName(String resourceName, Method method) {
        if (StringUtil.isNotBlank((String)resourceName)) {
            return resourceName;
        }
        return MethodUtil.resolveMethodName((Method)method);
    }

    protected Object handleFallback(Invocation inv, SentinelResource annotation, Throwable ex) throws Throwable {
        return this.handleFallback(inv, annotation.fallback(), annotation.defaultFallback(), annotation.fallbackClass(), ex);
    }

    protected Object handleFallback(Invocation inv, String fallback, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Object[] originArgs = inv.getArgs();
        Method fallbackMethod = this.extractFallbackMethod(inv, fallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] args;
            int paramCount = fallbackMethod.getParameterTypes().length;
            if (paramCount == originArgs.length) {
                args = originArgs;
            } else {
                args = Arrays.copyOf(originArgs, originArgs.length + 1);
                args[args.length - 1] = ex;
            }
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(inv.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleDefaultFallback(inv, defaultFallback, fallbackClass, ex);
    }

    protected Object handleDefaultFallback(Invocation inv, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Method fallbackMethod = this.extractDefaultFallbackMethod(inv, defaultFallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] objectArray;
            if (fallbackMethod.getParameterTypes().length == 0) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ex;
            }
            Object[] args = objectArray;
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(inv.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw ex;
    }

    protected Object handleBlockException(Invocation inv, SentinelResource annotation, BlockException ex) throws Throwable {
        Method blockHandlerMethod = this.extractBlockHandlerMethod(inv, annotation.blockHandler(), annotation.blockHandlerClass());
        if (blockHandlerMethod != null) {
            Object[] originArgs = inv.getArgs();
            Object[] args = Arrays.copyOf(originArgs, originArgs.length + 1);
            args[args.length - 1] = ex;
            try {
                if (this.isStatic(blockHandlerMethod)) {
                    return blockHandlerMethod.invoke(null, args);
                }
                return blockHandlerMethod.invoke(inv.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleFallback(inv, annotation, ex);
    }

    private Method extractFallbackMethod(Invocation inv, String fallbackName, Class<?>[] locationClass) {
        if (StringUtil.isBlank((String)fallbackName)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : inv.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupFallback(clazz, fallbackName);
        if (m == null) {
            Method method = this.resolveFallbackInternal(inv, fallbackName, clazz, mustStatic);
            ResourceMetadataRegistry.updateFallbackFor(clazz, fallbackName, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method extractDefaultFallbackMethod(Invocation inv, String defaultFallback, Class<?>[] locationClass) {
        if (StringUtil.isBlank((String)defaultFallback)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : inv.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupDefaultFallback(clazz, defaultFallback);
        if (m == null) {
            Class<?> originReturnType = this.resolveMethod(inv).getReturnType();
            Class[] defaultParamTypes = new Class[]{};
            Class[] paramTypeWithException = new Class[]{Throwable.class};
            Method method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, defaultParamTypes);
            if (method == null) {
                method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, paramTypeWithException);
            }
            ResourceMetadataRegistry.updateDefaultFallbackFor(clazz, defaultFallback, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveFallbackInternal(Invocation inv, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(inv);
        Class<?>[] defaultParamTypes = originMethod.getParameterTypes();
        Class<?>[] paramTypesWithException = Arrays.copyOf(defaultParamTypes, defaultParamTypes.length + 1);
        paramTypesWithException[paramTypesWithException.length - 1] = Throwable.class;
        Method method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), defaultParamTypes);
        if (method == null) {
            method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), paramTypesWithException);
        }
        return method;
    }

    private Method extractBlockHandlerMethod(Invocation inv, String name, Class<?>[] locationClass) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : inv.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupBlockHandler(clazz, name);
        if (m == null) {
            Method method = this.resolveBlockHandlerInternal(inv, name, clazz, mustStatic);
            ResourceMetadataRegistry.updateBlockHandlerFor(clazz, name, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveBlockHandlerInternal(Invocation inv, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(inv);
        Class<?>[] originList = originMethod.getParameterTypes();
        Class<?>[] parameterTypes = Arrays.copyOf(originList, originList.length + 1);
        parameterTypes[parameterTypes.length - 1] = BlockException.class;
        return this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), parameterTypes);
    }

    private boolean checkStatic(boolean mustStatic, Method method) {
        return !mustStatic || this.isStatic(method);
    }

    private Method findMethod(boolean mustStatic, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !this.checkStatic(mustStatic, method) || !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            RecordLog.info((String)"Resolved method [{0}] in class [{1}]", (Object[])new Object[]{name, clazz.getCanonicalName()});
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return this.findMethod(mustStatic, superClass, name, returnType, parameterTypes);
        }
        String methodType = mustStatic ? " static" : "";
        RecordLog.warn((String)"Cannot find{0} method [{1}] in class [{2}] with parameters {3}", (Object[])new Object[]{methodType, name, clazz.getCanonicalName(), Arrays.toString(parameterTypes)});
        return null;
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    protected Method resolveMethod(Invocation inv) {
        return inv.getMethod();
    }
}

