/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.tcc;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.seata.tcc.ActionInterceptorHandler;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import java.lang.reflect.Method;

public class TccActionInterceptor
implements Interceptor {
    private ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        if (!JbootSeataManager.me().isEnable()) {
            inv.invoke();
            return;
        }
        if (!RootContext.inGlobalTransaction()) {
            inv.invoke();
            return;
        }
        Method method = inv.getMethod();
        TwoPhaseBusinessAction businessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            BranchType previousBranchType = RootContext.getBranchType();
            if (BranchType.TCC != previousBranchType) {
                RootContext.bindBranchType((BranchType)BranchType.TCC);
            }
            try {
                Object[] methodArgs = inv.getArgs();
                this.actionInterceptorHandler.proceed(method, methodArgs, xid, businessAction, inv);
            }
            finally {
                if (BranchType.TCC != previousBranchType) {
                    RootContext.unbindBranchType();
                }
            }
        } else {
            inv.invoke();
        }
    }
}

