/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.tcc;

import com.alibaba.fastjson.JSON;
import com.jfinal.aop.Invocation;
import com.jfinal.log.Log;
import io.jboot.support.seata.tcc.TccActionInterceptor;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.NetUtil;
import io.seata.common.util.ReflectionUtil;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.TCCResource;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;

public class ActionInterceptorHandler {
    private static final Log LOGGER = Log.getLog(TccActionInterceptor.class);

    public void proceed(Method method, Object[] arguments, String xid, TwoPhaseBusinessAction businessAction, Invocation invocation) {
        String actionName = businessAction.name();
        BusinessActionContext actionContext = new BusinessActionContext();
        actionContext.setXid(xid);
        actionContext.setActionName(actionName);
        Class[] types = method.getParameterTypes();
        Parameter[] parameters = invocation.getMethod().getParameters();
        int argIndex = 0;
        for (Class<?> clazz : types) {
            if (clazz.getName().equals(BusinessActionContext.class.getName())) {
                arguments[argIndex] = actionContext;
                break;
            }
            ++argIndex;
        }
        String branchId = this.doTccActionLogStore(method, parameters, arguments, businessAction, actionContext);
        try {
            this.registryResource(method, invocation.getTarget(), types, businessAction);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        actionContext.setBranchId(branchId);
        invocation.invoke();
    }

    protected String doTccActionLogStore(Method method, Parameter[] parameters, Object[] arguments, TwoPhaseBusinessAction businessAction, BusinessActionContext actionContext) {
        String actionName = actionContext.getActionName();
        String xid = actionContext.getXid();
        Map<String, Object> context = this.fetchActionRequestContext(method, arguments, parameters);
        context.put("action-start-time", System.currentTimeMillis());
        this.initBusinessContext(context, method, businessAction);
        this.initFrameworkContext(context);
        actionContext.setActionContext(context);
        HashMap<String, Map<String, Object>> applicationContext = new HashMap<String, Map<String, Object>>(4);
        applicationContext.put("actionContext", context);
        String applicationContextStr = JSON.toJSONString(applicationContext);
        try {
            Long branchId = DefaultResourceManager.get().branchRegister(BranchType.TCC, actionName, null, xid, applicationContextStr, null);
            return String.valueOf(branchId);
        }
        catch (Throwable t) {
            String msg = String.format("TCC branch Register error, xid: %s", xid);
            LOGGER.error(msg, t);
            throw new FrameworkException(t, msg);
        }
    }

    protected void initFrameworkContext(Map<String, Object> context) {
        try {
            context.put("host-name", NetUtil.getLocalIp());
        }
        catch (Throwable t) {
            LOGGER.warn("getLocalIP error", t);
        }
    }

    protected void initBusinessContext(Map<String, Object> context, Method method, TwoPhaseBusinessAction businessAction) {
        if (method != null) {
            context.put("sys::prepare", method.getName());
        }
        if (businessAction != null) {
            context.put("sys::commit", businessAction.commitMethod());
            context.put("sys::rollback", businessAction.rollbackMethod());
            context.put("actionName", businessAction.name());
        }
    }

    protected Map<String, Object> fetchActionRequestContext(Method method, Object[] arguments, Parameter[] parameters) {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        int x = 0;
        for (Parameter p : parameters) {
            if (!p.isNamePresent()) {
                throw new RuntimeException(" Maven or IDE config is error. see https://jfinal.com/doc/3-3 ");
            }
            if (!"io.seata.rm.tcc.api.BusinessActionContext".equals(p.getType().getName())) {
                context.put(p.getName(), arguments[x]);
            }
            ++x;
        }
        return context;
    }

    public void registryResource(Method m, Object interfaceClass, Class[] arguments, TwoPhaseBusinessAction businessAction) throws NoSuchMethodException {
        if (businessAction != null) {
            TCCResource tccResource = new TCCResource();
            tccResource.setActionName(businessAction.name());
            tccResource.setTargetBean(interfaceClass);
            tccResource.setPrepareMethod(m);
            tccResource.setCommitMethodName(businessAction.commitMethod());
            tccResource.setCommitMethod(ReflectionUtil.getMethod(interfaceClass.getClass(), (String)businessAction.commitMethod(), (Class[])new Class[]{BusinessActionContext.class}));
            tccResource.setRollbackMethodName(businessAction.rollbackMethod());
            tccResource.setRollbackMethod(ReflectionUtil.getMethod(interfaceClass.getClass(), (String)businessAction.rollbackMethod(), (Class[])new Class[]{BusinessActionContext.class}));
            DefaultResourceManager.get().registerResource((Resource)tccResource);
        }
    }
}

