/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.seata.annotation.SeataGlobalLock;
import io.jboot.support.seata.annotation.SeataGlobalTransactional;
import io.jboot.support.seata.interceptor.SeataGlobalTransactionHandler;
import io.seata.core.model.GlobalLockConfig;
import io.seata.rm.GlobalLockExecutor;
import java.lang.reflect.Method;

public class SeataGlobalTransactionalInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        if (!JbootSeataManager.me().isEnable()) {
            inv.invoke();
            return;
        }
        Method method = inv.getMethod();
        SeataGlobalTransactional globalTrxAnno = method.getAnnotation(SeataGlobalTransactional.class);
        SeataGlobalLock globalLockAnno = method.getAnnotation(SeataGlobalLock.class);
        try {
            if (globalTrxAnno != null) {
                this.handleGlobalTransaction(inv, globalTrxAnno);
            } else if (globalLockAnno != null) {
                this.handleGlobalLock(inv, globalLockAnno);
            } else {
                inv.invoke();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void handleGlobalLock(final Invocation inv, final SeataGlobalLock globalLockAnno) throws Throwable {
        JbootSeataManager.me().getGlobalLockTemplate().execute(new GlobalLockExecutor(){

            public Object execute() throws Throwable {
                inv.invoke();
                return inv.getReturnValue();
            }

            public GlobalLockConfig getGlobalLockConfig() {
                GlobalLockConfig config = new GlobalLockConfig();
                config.setLockRetryInternal(globalLockAnno.lockRetryInternal());
                config.setLockRetryTimes(globalLockAnno.lockRetryTimes());
                return config;
            }
        });
    }

    private Object handleGlobalTransaction(Invocation invocation, SeataGlobalTransactional globalTrxAnno) throws Throwable {
        return SeataGlobalTransactionHandler.handleGlobalTransaction(invocation, globalTrxAnno);
    }
}

