/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis.jedis;

import com.jfinal.log.Log;
import io.jboot.exception.JbootException;
import io.jboot.support.redis.JbootRedisBase;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.support.redis.RedisScanResult;
import io.jboot.utils.QuietlyUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class JbootJedisClusterImpl
extends JbootRedisBase {
    protected JedisCluster jedisCluster;
    private int timeout = 2000;
    private int maxAttempts = 5;
    static final Log LOG = Log.getLog(JbootJedisClusterImpl.class);

    public JbootJedisClusterImpl(JbootRedisConfig config) {
        super(config);
        Integer timeout = config.getTimeout();
        String password = config.getPassword();
        Integer maxAttempts = config.getMaxAttempts();
        if (timeout != null) {
            this.timeout = timeout;
        }
        if (maxAttempts == null) {
            maxAttempts = this.maxAttempts;
        }
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        if (StrUtil.isNotBlank(config.getTestWhileIdle())) {
            poolConfig.setTestWhileIdle(config.getTestWhileIdle().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnBorrow())) {
            poolConfig.setTestOnBorrow(config.getTestOnBorrow().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnCreate())) {
            poolConfig.setTestOnCreate(config.getTestOnCreate().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnReturn())) {
            poolConfig.setTestOnReturn(config.getTestOnReturn().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getMinEvictableIdleTimeMillis())) {
            poolConfig.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis().longValue());
        }
        if (StrUtil.isNotBlank(config.getTimeBetweenEvictionRunsMillis())) {
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (StrUtil.isNotBlank(config.getNumTestsPerEvictionRun())) {
            poolConfig.setNumTestsPerEvictionRun(config.getNumTestsPerEvictionRun().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxTotal())) {
            poolConfig.setMaxTotal(config.getMaxTotal().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxIdle())) {
            poolConfig.setMaxIdle(config.getMaxIdle().intValue());
        }
        if (StrUtil.isNotBlank(config.getMinIdle())) {
            poolConfig.setMinIdle(config.getMinIdle().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxWaitMillis())) {
            poolConfig.setMaxWaitMillis((long)config.getMaxWaitMillis().intValue());
        }
        this.jedisCluster = JbootJedisClusterImpl.newJedisCluster(config.getHostAndPorts(), timeout, maxAttempts, password, poolConfig);
    }

    public static JedisCluster newJedisCluster(Set<HostAndPort> haps, Integer timeout, Integer maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        JedisCluster jedisCluster = timeout != null && maxAttempts != null && password != null && poolConfig != null ? new JedisCluster(haps, timeout.intValue(), timeout.intValue(), maxAttempts.intValue(), password, poolConfig) : (timeout != null && maxAttempts != null && poolConfig != null ? new JedisCluster(haps, timeout.intValue(), maxAttempts.intValue(), poolConfig) : (timeout != null && maxAttempts != null ? new JedisCluster(haps, timeout.intValue(), maxAttempts.intValue()) : (timeout != null && poolConfig != null ? new JedisCluster(haps, timeout.intValue(), poolConfig) : (timeout != null ? new JedisCluster(haps, timeout.intValue()) : new JedisCluster(haps)))));
        return jedisCluster;
    }

    public JbootJedisClusterImpl(JedisCluster jedisCluster) {
        super(null);
        this.jedisCluster = jedisCluster;
    }

    @Override
    public String set(Object key, Object value) {
        return this.jedisCluster.set(this.keyToBytes(key), this.valueToBytes(value));
    }

    @Override
    public Long setnx(Object key, Object value) {
        return this.jedisCluster.setnx(this.keyToBytes(key), this.valueToBytes(value));
    }

    @Override
    public String setWithoutSerialize(Object key, Object value) {
        return this.jedisCluster.set(this.keyToBytes(key), value.toString().getBytes());
    }

    @Override
    public String setex(Object key, int seconds, Object value) {
        return this.jedisCluster.setex(this.keyToBytes(key), seconds, this.valueToBytes(value));
    }

    @Override
    public <T> T get(Object key) {
        return (T)this.valueFromBytes(this.jedisCluster.get(this.keyToBytes(key)));
    }

    @Override
    public String getWithoutSerialize(Object key) {
        byte[] bytes = this.jedisCluster.get(this.keyToBytes(key));
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(this.jedisCluster.get(this.keyToBytes(key)));
    }

    @Override
    public Long del(Object key) {
        return this.jedisCluster.del(this.keyToBytes(key));
    }

    @Override
    public Long del(Object ... keys) {
        return this.jedisCluster.del(this.keysToBytesArray(keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            try (Jedis jedis = jp.getResource();){
                keys.addAll(jedis.keys(pattern));
            }
        }
        return keys;
    }

    @Override
    public String mset(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        byte[][] kv = new byte[keysValues.length][];
        for (int i = 0; i < keysValues.length; ++i) {
            kv[i] = i % 2 == 0 ? this.keyToBytes(keysValues[i]) : this.valueToBytes(keysValues[i]);
        }
        return this.jedisCluster.mset((byte[][])kv);
    }

    @Override
    public List mget(Object ... keys) {
        byte[][] keysBytesArray = this.keysToBytesArray(keys);
        List data = this.jedisCluster.mget(keysBytesArray);
        return this.valueListFromBytesList(data);
    }

    @Override
    public Long decr(Object key) {
        return this.jedisCluster.decr(this.keyToBytes(key));
    }

    @Override
    public Long decrBy(Object key, long longValue) {
        return this.jedisCluster.decrBy(this.keyToBytes(key), longValue);
    }

    @Override
    public Long incr(Object key) {
        return this.jedisCluster.incr(this.keyToBytes(key));
    }

    @Override
    public Long incrBy(Object key, long longValue) {
        return this.jedisCluster.incrBy(this.keyToBytes(key), longValue);
    }

    @Override
    public boolean exists(Object key) {
        return this.jedisCluster.exists(this.keyToBytes(key));
    }

    @Override
    public String randomKey() {
        throw new JbootException("not support randomKey commmand in redis cluster.");
    }

    @Override
    public String rename(Object oldkey, Object newkey) {
        return this.jedisCluster.rename(this.keyToBytes(oldkey), this.keyToBytes(newkey));
    }

    @Override
    public Long move(Object key, int dbIndex) {
        throw new JbootException("not support move commmand in redis cluster.");
    }

    @Override
    public String migrate(String host, int port, Object key, int destinationDb, int timeout) {
        throw new JbootException("not support migrate commmand in redis cluster.");
    }

    @Override
    public String select(int databaseIndex) {
        throw new IllegalStateException("Redis Cluster does not support multiple databases like the stand alone version of Redis, there is just database 0, and SELECT is not allowed.");
    }

    @Override
    public Long expire(Object key, int seconds) {
        return this.jedisCluster.expire(this.keyToBytes(key), seconds);
    }

    @Override
    public Long expireAt(Object key, long unixTime) {
        return this.jedisCluster.expireAt(this.keyToBytes(key), unixTime);
    }

    @Override
    public Long pexpire(Object key, long milliseconds) {
        return this.jedisCluster.pexpire(this.keyToBytes(key), milliseconds);
    }

    @Override
    public Long pexpireAt(Object key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(this.keyToBytes(key), millisecondsTimestamp);
    }

    @Override
    public <T> T getSet(Object key, Object value) {
        return (T)this.valueFromBytes(this.jedisCluster.getSet(this.keyToBytes(key), this.valueToBytes(value)));
    }

    @Override
    public Long persist(Object key) {
        return this.jedisCluster.persist(this.keyToBytes(key));
    }

    @Override
    public String type(Object key) {
        return this.jedisCluster.type(this.keyToBytes(key));
    }

    @Override
    public Long ttl(Object key) {
        return this.jedisCluster.ttl(this.keyToBytes(key));
    }

    @Override
    public Long pttl(Object key) {
        return this.jedisCluster.pttl(key.toString());
    }

    @Override
    public Long objectRefcount(Object key) {
        throw new JbootException("not support move objectRefcount in redis cluster.");
    }

    @Override
    public Long objectIdletime(Object key) {
        throw new JbootException("not support move objectIdletime in redis cluster.");
    }

    @Override
    public Long hset(Object key, Object field, Object value) {
        return this.jedisCluster.hset(this.keyToBytes(key), this.valueToBytes(field), this.valueToBytes(value));
    }

    @Override
    public String hmset(Object key, Map<Object, Object> hash) {
        HashMap<byte[], byte[]> para = new HashMap<byte[], byte[]>();
        for (Map.Entry<Object, Object> e : hash.entrySet()) {
            para.put(this.valueToBytes(e.getKey()), this.valueToBytes(e.getValue()));
        }
        return this.jedisCluster.hmset(this.keyToBytes(key), para);
    }

    @Override
    public <T> T hget(Object key, Object field) {
        return (T)this.valueFromBytes(this.jedisCluster.hget(this.keyToBytes(key), this.valueToBytes(field)));
    }

    @Override
    public List hmget(Object key, Object ... fields) {
        List data = this.jedisCluster.hmget(this.keyToBytes(key), this.valuesToBytesArray(fields));
        return this.valueListFromBytesList(data);
    }

    @Override
    public Long hdel(Object key, Object ... fields) {
        return this.jedisCluster.hdel(this.keyToBytes(key), this.valuesToBytesArray(fields));
    }

    @Override
    public boolean hexists(Object key, Object field) {
        return this.jedisCluster.hexists(this.keyToBytes(key), this.valueToBytes(field));
    }

    @Override
    public Map hgetAll(Object key) {
        Map data = this.jedisCluster.hgetAll(this.keyToBytes(key));
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry e : data.entrySet()) {
            result.put(this.valueFromBytes((byte[])e.getKey()), this.valueFromBytes((byte[])e.getValue()));
        }
        return result;
    }

    @Override
    public List hvals(Object key) {
        List data = this.jedisCluster.hvals(this.keyToBytes(key));
        return this.valueListFromBytesList(data);
    }

    @Override
    public Set<Object> hkeys(Object key) {
        Set fieldSet = this.jedisCluster.hkeys(this.keyToBytes(key));
        HashSet<Object> result = new HashSet<Object>();
        this.fieldSetFromBytesSet(fieldSet, result);
        return result;
    }

    @Override
    public Long hlen(Object key) {
        return this.jedisCluster.hlen(this.keyToBytes(key));
    }

    @Override
    public Long hincrBy(Object key, Object field, long value) {
        return this.jedisCluster.hincrBy(this.keyToBytes(key), this.valueToBytes(field), value);
    }

    @Override
    public Double hincrByFloat(Object key, Object field, double value) {
        return this.jedisCluster.hincrByFloat(this.keyToBytes(key), this.valueToBytes(field), value);
    }

    @Override
    public <T> T lindex(Object key, long index) {
        return (T)this.valueFromBytes(this.jedisCluster.lindex(this.keyToBytes(key), index));
    }

    @Override
    public Long llen(Object key) {
        return this.jedisCluster.llen(this.keyToBytes(key));
    }

    @Override
    public <T> T lpop(Object key) {
        return (T)this.valueFromBytes(this.jedisCluster.lpop(this.keyToBytes(key)));
    }

    @Override
    public Long lpush(Object key, Object ... values) {
        return this.jedisCluster.lpush(this.keyToBytes(key), this.valuesToBytesArray(values));
    }

    @Override
    public String lset(Object key, long index, Object value) {
        return this.jedisCluster.lset(this.keyToBytes(key), index, this.valueToBytes(value));
    }

    @Override
    public Long lrem(Object key, long count, Object value) {
        return this.jedisCluster.lrem(this.keyToBytes(key), count, this.valueToBytes(value));
    }

    @Override
    public List lrange(Object key, long start, long end) {
        List data = this.jedisCluster.lrange(this.keyToBytes(key), start, end);
        if (data != null) {
            return this.valueListFromBytesList(data);
        }
        return new ArrayList(0);
    }

    @Override
    public String ltrim(Object key, long start, long end) {
        return this.jedisCluster.ltrim(this.keyToBytes(key), start, end);
    }

    @Override
    public <T> T rpop(Object key) {
        return (T)this.valueFromBytes(this.jedisCluster.rpop(this.keyToBytes(key)));
    }

    @Override
    public <T> T rpoplpush(Object srcKey, Object dstKey) {
        return (T)this.valueFromBytes(this.jedisCluster.rpoplpush(this.keyToBytes(srcKey), this.keyToBytes(dstKey)));
    }

    @Override
    public Long rpush(Object key, Object ... values) {
        return this.jedisCluster.rpush(this.keyToBytes(key), this.valuesToBytesArray(values));
    }

    @Override
    public List blpop(Object ... keys) {
        List data = this.jedisCluster.blpop(this.timeout, this.keysToBytesArray(keys));
        if (data != null && data.size() == 2) {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(new String((byte[])data.get(0)));
            objects.add(this.valueFromBytes((byte[])data.get(1)));
            return objects;
        }
        return this.valueListFromBytesList(data);
    }

    @Override
    public List blpop(Integer timeout, Object ... keys) {
        List data = this.jedisCluster.blpop(timeout.intValue(), this.keysToBytesArray(keys));
        return this.valueListFromBytesList(data);
    }

    @Override
    public List brpop(Object ... keys) {
        List data = this.jedisCluster.brpop(this.timeout, this.keysToBytesArray(keys));
        return this.valueListFromBytesList(data);
    }

    @Override
    public List brpop(Integer timeout, Object ... keys) {
        List data = this.jedisCluster.brpop(timeout.intValue(), this.keysToBytesArray(keys));
        return this.valueListFromBytesList(data);
    }

    @Override
    public String ping() {
        Map nodes = this.jedisCluster.getClusterNodes();
        if (nodes != null) {
            for (JedisPool pool : nodes.values()) {
                Jedis node = pool.getResource();
                Throwable throwable = null;
                try {
                    String ret = node.ping();
                    if (ret == null) continue;
                    String string = ret;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (node == null) continue;
                    if (throwable != null) {
                        try {
                            node.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    node.close();
                }
            }
        }
        return null;
    }

    @Override
    public Long sadd(Object key, Object ... members) {
        return this.jedisCluster.sadd(this.keyToBytes(key), this.valuesToBytesArray(members));
    }

    @Override
    public Long scard(Object key) {
        return this.jedisCluster.scard(this.keyToBytes(key));
    }

    @Override
    public <T> T spop(Object key) {
        return (T)this.valueFromBytes(this.jedisCluster.spop(this.keyToBytes(key)));
    }

    @Override
    public Set smembers(Object key) {
        Set data = this.jedisCluster.smembers(this.keyToBytes(key));
        HashSet<Object> result = new HashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public boolean sismember(Object key, Object member) {
        return this.jedisCluster.sismember(this.keyToBytes(key), this.valueToBytes(member));
    }

    @Override
    public Set sinter(Object ... keys) {
        Set data = this.jedisCluster.sinter(this.keysToBytesArray(keys));
        HashSet<Object> result = new HashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public <T> T srandmember(Object key) {
        return (T)this.valueFromBytes(this.jedisCluster.srandmember(this.keyToBytes(key)));
    }

    @Override
    public List srandmember(Object key, int count) {
        List data = this.jedisCluster.srandmember(this.keyToBytes(key), count);
        return this.valueListFromBytesList(data);
    }

    @Override
    public Long srem(Object key, Object ... members) {
        return this.jedisCluster.srem(this.keyToBytes(key), this.valuesToBytesArray(members));
    }

    @Override
    public Set sunion(Object ... keys) {
        Set data = this.jedisCluster.sunion(this.keysToBytesArray(keys));
        HashSet<Object> result = new HashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public Set sdiff(Object ... keys) {
        Set data = this.jedisCluster.sdiff(this.keysToBytesArray(keys));
        HashSet<Object> result = new HashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public Long zadd(Object key, double score, Object member) {
        return this.jedisCluster.zadd(this.keyToBytes(key), score, this.valueToBytes(member));
    }

    @Override
    public Long zadd(Object key, Map<Object, Double> scoreMembers) {
        HashMap<byte[], Double> para = new HashMap<byte[], Double>();
        for (Map.Entry<Object, Double> e : scoreMembers.entrySet()) {
            para.put(this.valueToBytes(e.getKey()), e.getValue());
        }
        return this.jedisCluster.zadd(this.keyToBytes(key), para);
    }

    @Override
    public Long zcard(Object key) {
        return this.jedisCluster.zcard(this.keyToBytes(key));
    }

    @Override
    public Long zcount(Object key, double min, double max) {
        return this.jedisCluster.zcount(this.keyToBytes(key), min, max);
    }

    @Override
    public Double zincrby(Object key, double score, Object member) {
        return this.jedisCluster.zincrby(this.keyToBytes(key), score, this.valueToBytes(member));
    }

    @Override
    public Set zrange(Object key, long start, long end) {
        Set data = this.jedisCluster.zrange(this.keyToBytes(key), start, end);
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public Set zrevrange(Object key, long start, long end) {
        Set data = this.jedisCluster.zrevrange(this.keyToBytes(key), start, end);
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public Set zrangeByScore(Object key, double min, double max) {
        Set data = this.jedisCluster.zrangeByScore(this.keyToBytes(key), min, max);
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        this.valueSetFromBytesSet(data, result);
        return result;
    }

    @Override
    public Long zrank(Object key, Object member) {
        return this.jedisCluster.zrank(this.keyToBytes(key), this.valueToBytes(member));
    }

    @Override
    public Long zrevrank(Object key, Object member) {
        return this.jedisCluster.zrevrank(this.keyToBytes(key), this.valueToBytes(member));
    }

    @Override
    public Long zrem(Object key, Object ... members) {
        return this.jedisCluster.zrem(this.keyToBytes(key), this.valuesToBytesArray(members));
    }

    @Override
    public Double zscore(Object key, Object member) {
        return this.jedisCluster.zscore(this.keyToBytes(key), this.valueToBytes(member));
    }

    @Override
    public void publish(String channel, String message) {
        this.jedisCluster.publish(channel, message);
    }

    @Override
    public void publish(byte[] channel, byte[] message) {
        this.jedisCluster.publish(channel, message);
    }

    @Override
    public void subscribe(final JedisPubSub listener, final String ... channels) {
        new Thread("jboot-redisCluster-subscribe-JedisPubSub"){

            @Override
            public void run() {
                while (true) {
                    try {
                        JbootJedisClusterImpl.this.jedisCluster.subscribe(listener, channels);
                        LOG.warn("Disconnect to redis channel in subscribe JedisPubSub!");
                    }
                    catch (JedisConnectionException e) {
                        LOG.error("failed connect to redis, reconnect it.", (Throwable)e);
                        QuietlyUtil.sleepQuietly(1000L);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void subscribe(final BinaryJedisPubSub binaryListener, final byte[] ... channels) {
        new Thread("jboot-redisCluster-subscribe-BinaryJedisPubSub"){

            @Override
            public void run() {
                while (!JbootJedisClusterImpl.this.isClose()) {
                    try {
                        JbootJedisClusterImpl.this.jedisCluster.subscribe(binaryListener, channels);
                        LOG.warn("Disconnect to redis channel in subscribe BinaryJedisPubSub!");
                        break;
                    }
                    catch (Throwable e) {
                        LOG.error("failed connect to redis, reconnect it.", e);
                        QuietlyUtil.sleepQuietly(1000L);
                    }
                }
            }
        }.start();
    }

    @Override
    public RedisScanResult<String> scan(String pattern, String cursor, int scanCount) {
        ScanParams params = new ScanParams();
        params.match(pattern).count(Integer.valueOf(scanCount));
        ScanResult scanResult = this.jedisCluster.scan(cursor, params);
        return new RedisScanResult<String>(scanResult.getCursor(), scanResult.getResult());
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        return this.jedisCluster.eval(script, keyCount, params);
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }
}

