/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis;

import io.jboot.Jboot;
import io.jboot.exception.JbootException;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.support.redis.jedis.JbootJedisClusterImpl;
import io.jboot.support.redis.jedis.JbootJedisImpl;
import io.jboot.utils.ConfigUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootRedisManager {
    private static JbootRedisManager manager = new JbootRedisManager();
    private JbootRedis redis;
    private Map<String, JbootRedis> jbootRedisMap = new ConcurrentHashMap<String, JbootRedis>();

    private JbootRedisManager() {
    }

    public static JbootRedisManager me() {
        return manager;
    }

    public JbootRedis getRedis() {
        if (this.redis == null) {
            JbootRedisConfig config = Jboot.config(JbootRedisConfig.class);
            this.redis = this.getRedis(config);
        }
        return this.redis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JbootRedis getRedis(String name) {
        JbootRedis redis = this.jbootRedisMap.get(name);
        if (redis == null) {
            JbootRedisManager jbootRedisManager = this;
            synchronized (jbootRedisManager) {
                redis = this.jbootRedisMap.get(name);
                if (redis == null) {
                    Map<String, JbootRedisConfig> configModels = ConfigUtil.getConfigModels(JbootRedisConfig.class);
                    if (!configModels.containsKey(name)) {
                        throw new JbootIllegalConfigException("Please config \"jboot.redis." + name + ".host\" in your jboot.properties.");
                    }
                    JbootRedisConfig jbootRedisConfig = configModels.get(name);
                    redis = this.getRedis(jbootRedisConfig);
                    if (redis != null) {
                        this.jbootRedisMap.put(name, redis);
                    }
                }
            }
        }
        return redis;
    }

    public JbootRedis getRedis(JbootRedisConfig config) {
        if (config == null || !config.isConfigOk()) {
            return null;
        }
        switch (config.getType()) {
            case "jedis": {
                return this.getJedisClient(config);
            }
            case "lettuce": {
                return this.getLettuceClient(config);
            }
            case "redisson": {
                return this.getRedissonClient(config);
            }
        }
        return null;
    }

    private JbootRedis getJedisClient(JbootRedisConfig config) {
        if (config.isCluster()) {
            return new JbootJedisClusterImpl(config);
        }
        return new JbootJedisImpl(config);
    }

    private JbootRedis getLettuceClient(JbootRedisConfig config) {
        throw new JbootException("lettuce is not finished.");
    }

    private JbootRedis getRedissonClient(JbootRedisConfig config) {
        throw new JbootException("redisson is not finished.");
    }
}

