/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis;

import io.jboot.Jboot;
import io.jboot.support.redis.JbootRedis;
import io.jboot.utils.QuietlyUtil;

public class JbootRedisLock {
    long expireMsecs = 60000L;
    long timeoutMsecs = 0L;
    private String lockName;
    private boolean locked = false;
    private JbootRedis redis;

    public JbootRedisLock(String lockName) {
        if (lockName == null) {
            throw new NullPointerException("lockName must not null !");
        }
        this.lockName = lockName;
        this.redis = Jboot.getRedis();
    }

    public JbootRedisLock(String lockName, long timeoutMsecs) {
        if (lockName == null) {
            throw new NullPointerException("lockName must not null !");
        }
        this.lockName = lockName;
        this.timeoutMsecs = timeoutMsecs;
        this.redis = Jboot.getRedis();
    }

    public long getTimeoutMsecs() {
        return this.timeoutMsecs;
    }

    public void setTimeoutMsecs(long timeoutMsecs) {
        this.timeoutMsecs = timeoutMsecs;
    }

    public long getExpireMsecs() {
        return this.expireMsecs;
    }

    public void setExpireMsecs(long expireMsecs) {
        this.expireMsecs = expireMsecs;
    }

    public void runIfAcquired(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable must not null!");
        }
        try {
            if (this.acquire()) {
                runnable.run();
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire() {
        long timeout = this.timeoutMsecs;
        do {
            try {
                long expiredTime = System.currentTimeMillis() + this.expireMsecs + 1L;
                Long result = this.redis.setnx(this.lockName, expiredTime);
                if (result != null) {
                    Long oldValue;
                    if (result == 1L) {
                        this.locked = true;
                        boolean bl = true;
                        return bl;
                    }
                    Long savedValue = (Long)this.redis.get(this.lockName);
                    if (savedValue != null && savedValue < System.currentTimeMillis() && (oldValue = (Long)this.redis.getSet(this.lockName, expiredTime)) != null && oldValue.equals(savedValue)) {
                        this.locked = true;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                if (timeout > 0L) {
                    timeout -= 100L;
                    QuietlyUtil.sleepQuietly(100L);
                }
            }
        } while (timeout > 0L);
        return false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void release() {
        if (!this.isLocked()) {
            return;
        }
        if (Jboot.getRedis().del((Object)this.lockName) > 0L) {
            this.locked = false;
        }
    }
}

