/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis;

import io.jboot.Jboot;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.components.serializer.JbootSerializerManager;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class JbootRedisBase
implements JbootRedis {
    private final JbootSerializer serializer;
    private boolean close = false;

    public JbootRedisBase(JbootRedisConfig config) {
        this.serializer = config == null || StrUtil.isBlank((String)config.getSerializer()) ? Jboot.getSerializer() : JbootSerializerManager.me().getSerializer(config.getSerializer());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.close = true;
            System.err.println("JbootApplication exited, redis disconnection.");
        }, "jboot-redis-hook"));
    }

    public boolean isClose() {
        return this.close;
    }

    @Override
    public byte[] keyToBytes(Object key) {
        return key.toString().getBytes();
    }

    @Override
    public String bytesToKey(byte[] bytes) {
        return new String(bytes);
    }

    @Override
    public byte[][] keysToBytesArray(Object ... keys) {
        byte[][] result = new byte[keys.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.keyToBytes(keys[i]);
        }
        return result;
    }

    @Override
    public void fieldSetFromBytesSet(Set<byte[]> data, Set<Object> result) {
        for (byte[] fieldBytes : data) {
            result.add(this.valueFromBytes(fieldBytes));
        }
    }

    @Override
    public byte[] valueToBytes(Object value) {
        return this.serializer.serialize(value);
    }

    @Override
    public Object valueFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return this.serializer.deserialize(bytes);
    }

    @Override
    public byte[][] valuesToBytesArray(Object ... valuesArray) {
        byte[][] data = new byte[valuesArray.length][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.valueToBytes(valuesArray[i]);
        }
        return data;
    }

    @Override
    public void valueSetFromBytesSet(Set<byte[]> data, Set<Object> result) {
        for (byte[] valueBytes : data) {
            result.add(this.valueFromBytes(valueBytes));
        }
    }

    @Override
    public List valueListFromBytesList(Collection<byte[]> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (byte[] d : data) {
            Object object = null;
            try {
                object = this.valueFromBytes(d);
            }
            catch (Throwable ex) {
                object = new String(d);
            }
            result.add(object);
        }
        return result;
    }
}

