/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.request;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.jfinal.handler.Handler;
import io.jboot.Jboot;
import io.jboot.support.metric.JbootMetricConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class AbstractInstrumentedFilter
extends Handler {
    private final Map<Integer, String> meterNamesByStatusCode;
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Meter timeoutsMeter;
    private Meter errorsMeter;
    private Counter activeRequests;
    private Timer requestTimer;
    private JbootMetricConfig jbootMetricConfig = Jboot.config(JbootMetricConfig.class);

    protected AbstractInstrumentedFilter(Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.meterNamesByStatusCode = meterNamesByStatusCode;
        MetricRegistry metricsRegistry = Jboot.getMetric();
        String metricName = this.jbootMetricConfig.getRequestMetricName();
        if (metricName == null || metricName.isEmpty()) {
            metricName = ((Object)((Object)this)).getClass().getName();
        }
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{entry.getValue()})));
        }
        this.otherMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{otherMetricName}));
        this.timeoutsMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"timeouts"}));
        this.errorsMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"errors"}));
        this.activeRequests = metricsRegistry.counter(MetricRegistry.name((String)metricName, (String[])new String[]{"activeRequests"}));
        this.requestTimer = metricsRegistry.timer(MetricRegistry.name((String)metricName, (String[])new String[]{"requests"}));
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse(response);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        boolean error = false;
        try {
            this.next.handle(target, request, (HttpServletResponse)wrappedResponse, isHandled);
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            if (!error && request.isAsyncStarted()) {
                request.getAsyncContext().addListener((AsyncListener)new AsyncResultListener(context));
            } else {
                context.stop();
                this.activeRequests.dec();
                if (error) {
                    this.errorsMeter.mark();
                } else {
                    this.markMeterForStatusCode(wrappedResponse.getStatus());
                }
            }
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private class AsyncResultListener
    implements AsyncListener {
        private Timer.Context context;
        private boolean done = false;

        public AsyncResultListener(Timer.Context context) {
            this.context = context;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            if (!this.done) {
                HttpServletResponse suppliedResponse = (HttpServletResponse)event.getSuppliedResponse();
                this.context.stop();
                AbstractInstrumentedFilter.this.activeRequests.dec();
                AbstractInstrumentedFilter.this.markMeterForStatusCode(suppliedResponse.getStatus());
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.context.stop();
            AbstractInstrumentedFilter.this.activeRequests.dec();
            AbstractInstrumentedFilter.this.timeoutsMeter.mark();
            this.done = true;
        }

        public void onError(AsyncEvent event) throws IOException {
            this.context.stop();
            AbstractInstrumentedFilter.this.activeRequests.dec();
            AbstractInstrumentedFilter.this.errorsMeter.mark();
            this.done = true;
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

