/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.reporter.prometheus;

import com.codahale.metrics.MetricRegistry;
import io.jboot.Jboot;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.metric.JbootMetricReporter;
import io.jboot.support.metric.reporter.prometheus.PrometheusExports;
import io.jboot.support.metric.reporter.prometheus.PrometheusReporterConfig;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;

public class PrometheusReporter
implements JbootMetricReporter {
    private HTTPServer httpServer;

    public PrometheusReporter() {
        PrometheusReporterConfig config = Jboot.config(PrometheusReporterConfig.class);
        try {
            this.httpServer = new HTTPServer(config.getHost(), config.getPort());
            String printMsg = "Prometheus Reporter Server started -> http://" + config.getHost() + ":" + config.getPort();
            System.out.println(printMsg);
        }
        catch (IOException e) {
            throw new JbootIllegalConfigException("Prometheus config is error, please check your jboot.properties. ", e);
        }
    }

    @Override
    public void report(MetricRegistry metricRegistry) {
        new PrometheusExports(metricRegistry).register();
    }
}

