/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.interceptor;

import io.jboot.Jboot;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.support.metric.JbootMetricConfig;
import io.jboot.support.metric.annotation.EnableMetricConcurrency;
import io.jboot.support.metric.annotation.EnableMetricCounter;
import io.jboot.support.metric.annotation.EnableMetricHistogram;
import io.jboot.support.metric.annotation.EnableMetricMeter;
import io.jboot.support.metric.annotation.EnableMetricTimer;
import io.jboot.support.metric.interceptor.MetricConcurrencyInterceptor;
import io.jboot.support.metric.interceptor.MetricCounterInterceptor;
import io.jboot.support.metric.interceptor.MetricHistogramInterceptor;
import io.jboot.support.metric.interceptor.MetricMeterInterceptor;
import io.jboot.support.metric.interceptor.MetricTimerInterceptor;
import java.lang.reflect.Method;

@AutoLoad
public class MetricInterceptorBuilder
implements InterceptorBuilder {
    private static JbootMetricConfig config = Jboot.config(JbootMetricConfig.class);

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (!config.isConfigOk() || !config.isEnable()) {
            return;
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableMetricConcurrency.class)) {
            interceptors.add(MetricConcurrencyInterceptor.class);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableMetricHistogram.class)) {
            interceptors.add(MetricHistogramInterceptor.class);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableMetricCounter.class)) {
            interceptors.add(MetricCounterInterceptor.class);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableMetricMeter.class)) {
            interceptors.add(MetricMeterInterceptor.class);
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableMetricTimer.class)) {
            interceptors.add(MetricTimerInterceptor.class);
        }
    }
}

