/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.interceptor;

import com.codahale.metrics.Histogram;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.support.metric.annotation.EnableMetricHistogram;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;

public class MetricHistogramInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        EnableMetricHistogram histogramAnnotation = inv.getMethod().getAnnotation(EnableMetricHistogram.class);
        if (histogramAnnotation != null) {
            String value = AnnotationUtil.get(histogramAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".histogram" : value;
            Histogram histogram = Jboot.getMetric().histogram(name);
            histogram.update(histogramAnnotation.update());
        }
        inv.invoke();
    }
}

