/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.interceptor;

import com.codahale.metrics.Counter;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.support.metric.annotation.EnableMetricConcurrency;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;

public class MetricConcurrencyInterceptor
implements Interceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        Counter concurrencyRecord = null;
        EnableMetricConcurrency concurrencyAnnotation = inv.getMethod().getAnnotation(EnableMetricConcurrency.class);
        if (concurrencyAnnotation != null) {
            String value = AnnotationUtil.get(concurrencyAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".concurrency" : value;
            concurrencyRecord = Jboot.getMetric().counter(name);
            concurrencyRecord.inc();
        }
        try {
            inv.invoke();
        }
        finally {
            if (concurrencyRecord != null) {
                concurrencyRecord.dec();
            }
        }
    }
}

