/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessFilesGaugeSet
implements MetricSet {
    private static final List<String> UNIX_OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.UnixOperatingSystemMXBean");
    private final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private final Class<?> osBeanClass = this.getFirstClassFound(UNIX_OPERATING_SYSTEM_BEAN_CLASS_NAMES);
    private final Method openFilesMethod = this.detectMethod("getOpenFileDescriptorCount");
    private final Method maxFilesMethod = this.detectMethod("getMaxFileDescriptorCount");

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        if (this.openFilesMethod != null) {
            gauges.put("process.files.open", () -> this.invoke(this.openFilesMethod));
        }
        if (this.maxFilesMethod != null) {
            gauges.put("process.files.max", () -> this.invoke(this.maxFilesMethod));
        }
        return Collections.unmodifiableMap(gauges);
    }

    private double invoke(Method method) {
        try {
            return method != null ? (double)((Long)method.invoke((Object)this.osBean, new Object[0])).longValue() : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Double.NaN;
        }
    }

    private Method detectMethod(String name) {
        if (this.osBeanClass == null) {
            return null;
        }
        try {
            this.osBeanClass.cast(this.osBean);
            return this.osBeanClass.getDeclaredMethod(name, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private Class<?> getFirstClassFound(List<String> classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

