/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.jfinal.log.Log;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.jboot.support.metric.JvmGcUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class JvmGcMetrics
implements MetricSet,
AutoCloseable {
    private static final Log log = Log.getLog(JvmGcMetrics.class);
    private final boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    private MetricRegistry metricRegistry;
    private String youngGenPoolName;
    private String oldGenPoolName;
    private String nonGenerationalMemoryPool;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmGcUtil.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (JvmGcUtil.isOldGenPool(name)) {
                this.oldGenPoolName = name;
                continue;
            }
            if (!JvmGcUtil.isNonGenerationalHeapPool(name)) continue;
            this.nonGenerationalMemoryPool = name;
        }
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        if (!this.managementExtensionsPresent) {
            return gauges;
        }
        double maxLongLivedPoolBytes = JvmGcUtil.getLongLivedHeapPool().map(mem -> JvmGcUtil.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        AtomicLong maxDataSize = new AtomicLong((long)maxLongLivedPoolBytes);
        gauges.put("jvm.gc.max.data.size", (Metric)((Gauge)() -> maxDataSize.get()));
        AtomicLong liveDataSize = new AtomicLong();
        gauges.put("jvm.gc.live.data.size", (Metric)((Gauge)() -> liveDataSize.get()));
        Counter allocatedBytes = this.metricRegistry.counter("jvm.gc.memory.allocated");
        Counter promotedBytes = this.oldGenPoolName == null ? null : this.metricRegistry.counter("jvm.gc.memory.promoted");
        AtomicLong heapPoolSizeAfterGc = new AtomicLong();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (JvmGcUtil.isConcurrentPhase(gcCause, notificationInfo.getGcName())) {
                    this.metricRegistry.timer("jvm.gc.concurrent.phase.time").update(duration, TimeUnit.MICROSECONDS);
                } else {
                    this.metricRegistry.timer("jvm.gc.pause").update(duration, TimeUnit.MICROSECONDS);
                }
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.nonGenerationalMemoryPool != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.nonGenerationalMemoryPool);
                    if (after.get(this.nonGenerationalMemoryPool).getUsed() < before.get(this.nonGenerationalMemoryPool).getUsed()) {
                        liveDataSize.set(after.get(this.nonGenerationalMemoryPool).getUsed());
                        long longLivedMaxAfter = after.get(this.nonGenerationalMemoryPool).getMax();
                        maxDataSize.set(longLivedMaxAfter);
                    }
                    return;
                }
                if (this.oldGenPoolName != null) {
                    long oldBefore = before.get(this.oldGenPoolName).getUsed();
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    long delta = oldAfter - oldBefore;
                    if (delta > 0L) {
                        promotedBytes.inc(delta);
                    }
                    if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                        liveDataSize.set(oldAfter);
                        long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                        maxDataSize.set(oldMaxAfter);
                    }
                }
                if (this.youngGenPoolName != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.youngGenPoolName);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
        return gauges;
    }

    private void countPoolSizeDelta(Map<String, MemoryUsage> before, Map<String, MemoryUsage> after, Counter counter, AtomicLong previousPoolSize, String poolName) {
        long beforeBytes = before.get(poolName).getUsed();
        long afterBytes = after.get(poolName).getUsed();
        long delta = beforeBytes - previousPoolSize.get();
        previousPoolSize.set(afterBytes);
        if (delta > 0L) {
            counter.inc(delta);
        }
    }

    private static boolean isManagementExtensionsPresent() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            log.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            log.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }
}

