/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JvmCpuGaugeSet
implements MetricSet {
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    private final OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
    private final Class<?> operatingSystemBeanClass = this.getFirstClassFound(OPERATING_SYSTEM_BEAN_CLASS_NAMES);
    private final Method systemCpuUsage;
    private final Method processCpuUsage;

    public JvmCpuGaugeSet() {
        Method getCpuLoad = this.detectMethod("getCpuLoad");
        this.systemCpuUsage = getCpuLoad != null ? getCpuLoad : this.detectMethod("getSystemCpuLoad");
        this.processCpuUsage = this.detectMethod("getProcessCpuLoad");
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        Runtime runtime = Runtime.getRuntime();
        gauges.put("system.cpu.count", () -> runtime.availableProcessors());
        if (this.operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            gauges.put("system.load.average.1m", () -> this.operatingSystemBean.getSystemLoadAverage());
        }
        if (this.systemCpuUsage != null) {
            gauges.put("system.cpu.usage", () -> this.invoke(this.systemCpuUsage));
        }
        if (this.processCpuUsage != null) {
            gauges.put("process.cpu.usage", () -> this.invoke(this.processCpuUsage));
        }
        return Collections.unmodifiableMap(gauges);
    }

    private double invoke(Method method) {
        try {
            return method != null ? (Double)method.invoke((Object)this.operatingSystemBean, new Object[0]) : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Double.NaN;
        }
    }

    private Method detectMethod(String name) {
        if (this.operatingSystemBeanClass == null) {
            return null;
        }
        try {
            this.operatingSystemBeanClass.cast(this.operatingSystemBean);
            return this.operatingSystemBeanClass.getDeclaredMethod(name, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private Class<?> getFirstClassFound(List<String> classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

