/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.support.metric.JbootMetricConfig;
import io.jboot.support.metric.JbootMetricReporter;
import io.jboot.support.metric.JvmCpuGaugeSet;
import io.jboot.support.metric.JvmGcMetrics;
import io.jboot.support.metric.ProcessFilesGaugeSet;
import io.jboot.support.metric.reporter.console.JbootConsoleReporter;
import io.jboot.support.metric.reporter.csv.CSVReporter;
import io.jboot.support.metric.reporter.elasticsearch.ElasticsearchReporter;
import io.jboot.support.metric.reporter.ganglia.GangliaReporter;
import io.jboot.support.metric.reporter.graphite.JbootGraphiteReporter;
import io.jboot.support.metric.reporter.influxdb.InfluxdbReporter;
import io.jboot.support.metric.reporter.jmx.JMXReporter;
import io.jboot.support.metric.reporter.prometheus.PrometheusReporter;
import io.jboot.support.metric.reporter.slf4j.JbootSlf4jReporter;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JbootMetricManager {
    private static final Log LOG = Log.getLog(JbootMetricManager.class);
    private static JbootMetricManager me;
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;
    private JbootMetricConfig metricsConfig = Jboot.config(JbootMetricConfig.class);
    private boolean enable = false;

    public static JbootMetricManager me() {
        if (me == null) {
            me = new JbootMetricManager();
        }
        return me;
    }

    private JbootMetricManager() {
        List<JbootMetricReporter> reporters;
        if (!this.metricsConfig.isConfigOk() || !this.metricsConfig.isEnable()) {
            return;
        }
        this.metricRegistry = new MetricRegistry();
        this.healthCheckRegistry = new HealthCheckRegistry();
        if (this.metricsConfig.isJvmMetricEnable()) {
            this.metricRegistry.register("jvm.uptime", (Metric)((Gauge)() -> ManagementFactory.getRuntimeMXBean().getUptime()));
            this.metricRegistry.register("jvm.start_time", (Metric)((Gauge)() -> ManagementFactory.getRuntimeMXBean().getStartTime()));
            this.metricRegistry.register("jvm.current_time", (Metric)((Gauge)() -> System.nanoTime()));
            this.metricRegistry.register("jvm.classes", (Metric)new ClassLoadingGaugeSet());
            this.metricRegistry.register("jvm.attribute", (Metric)new JvmAttributeGaugeSet());
            this.metricRegistry.register("jvm.fd", (Metric)new FileDescriptorRatioGauge());
            this.metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
            this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
            this.metricRegistry.register("jvm.threads", (Metric)new CachedThreadStatesGaugeSet(10L, TimeUnit.SECONDS));
            this.metricRegistry.registerAll((MetricSet)new JvmCpuGaugeSet());
            this.metricRegistry.registerAll((MetricSet)new JvmGcMetrics(this.metricRegistry));
            this.metricRegistry.registerAll((MetricSet)new ProcessFilesGaugeSet());
            this.healthCheckRegistry.register("jvm.thread_deadlocks", (HealthCheck)new ThreadDeadlockHealthCheck());
        }
        if (ArrayUtil.isNullOrEmpty(reporters = this.getReporters())) {
            return;
        }
        for (JbootMetricReporter reporter : reporters) {
            try {
                reporter.report(this.metricRegistry);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
        this.enable = true;
    }

    public boolean isEnable() {
        return this.enable;
    }

    private List<JbootMetricReporter> getReporters() {
        String[] repoterStrings;
        String repoterString = this.metricsConfig.getReporter();
        if (StrUtil.isBlank((String)repoterString)) {
            return null;
        }
        ArrayList<JbootMetricReporter> reporters = new ArrayList<JbootMetricReporter>();
        for (String repoterName : repoterStrings = repoterString.split(",")) {
            JbootMetricReporter reporter = this.getReporterByName(repoterName);
            if (reporter == null) continue;
            reporters.add(reporter);
        }
        return reporters;
    }

    private JbootMetricReporter getReporterByName(String repoterName) {
        JbootMetricReporter reporter = null;
        switch (repoterName) {
            case "jmx": {
                reporter = new JMXReporter();
                break;
            }
            case "influxdb": {
                reporter = new InfluxdbReporter();
                break;
            }
            case "graphite": {
                reporter = new JbootGraphiteReporter();
                break;
            }
            case "elasticsearch": {
                reporter = new ElasticsearchReporter();
                break;
            }
            case "ganglia": {
                reporter = new GangliaReporter();
                break;
            }
            case "console": {
                reporter = new JbootConsoleReporter();
                break;
            }
            case "csv": {
                reporter = new CSVReporter();
                break;
            }
            case "slf4j": {
                reporter = new JbootSlf4jReporter();
                break;
            }
            case "prometheus": {
                reporter = new PrometheusReporter();
                break;
            }
            default: {
                reporter = JbootSpiLoader.load(JbootMetricReporter.class, repoterName);
            }
        }
        return reporter;
    }

    public MetricRegistry metric() {
        return this.metricRegistry;
    }

    public HealthCheckRegistry healthCheck() {
        return this.healthCheckRegistry;
    }
}

