/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.jwt;

import com.jfinal.core.Controller;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.jwt.JwtConfig;
import io.jboot.utils.StrUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class JwtManager {
    private static final JwtManager me = new JwtManager();
    private static final Log LOG = Log.getLog(JwtManager.class);
    public static final Map EMPTY_MAP = new HashMap();
    private static JwtConfig config = Jboot.config(JwtConfig.class);

    public static JwtManager me() {
        return me;
    }

    public String getHttpHeaderName() {
        return config.getHttpHeaderName();
    }

    public String getHttpParameterKey() {
        return config.getHttpParameterKey();
    }

    public Map parseJwtToken(Controller controller) {
        if (!config.isConfigOk()) {
            LogKit.debug((String)"Jwt secret not config well, please config jboot.web.jwt.secret in jboot.properties.");
            return EMPTY_MAP;
        }
        String token = controller.getHeader(this.getHttpHeaderName());
        if (StrUtil.isBlank((String)token) && StrUtil.isNotBlank(this.getHttpParameterKey())) {
            token = controller.get(this.getHttpParameterKey());
        }
        return StrUtil.isBlank((String)token) ? EMPTY_MAP : this.parseJwtToken(token);
    }

    public Map parseJwtToken(String token) {
        SecretKey secretKey = this.createSecretKey();
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(token).getBody();
            String jsonString = claims.getSubject();
            if (StrUtil.isNotBlank(jsonString)) {
                return (Map)JsonKit.parse((String)jsonString, HashMap.class);
            }
        }
        catch (MalformedJwtException | SignatureException ex) {
            LOG.error("Do not trast the jwt. " + ex.getMessage());
        }
        catch (ExpiredJwtException ex) {
            LOG.error("Jwt is expired. " + ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error("Jwt parseJwtToken error. " + ex.getMessage());
        }
        return EMPTY_MAP;
    }

    public String createJwtToken(Map map) {
        if (!config.isConfigOk()) {
            throw new JbootIllegalConfigException("Can not create jwt, please config jboot.web.jwt.secret in jboot.properties.");
        }
        SecretKey secretKey = this.createSecretKey();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        map.put("isuuedAt", nowMillis);
        String subject = JsonKit.toJson((Object)map);
        JwtBuilder builder = Jwts.builder().setIssuedAt(now).setSubject(subject).signWith(signatureAlgorithm, (Key)secretKey);
        if (config.getValidityPeriod() > 0L) {
            long expMillis = nowMillis + config.getValidityPeriod();
            builder.setExpiration(new Date(expMillis));
        }
        return builder.compact();
    }

    private SecretKey createSecretKey() {
        byte[] encodedKey = DatatypeConverter.parseBase64Binary((String)config.getSecret());
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    public static JwtConfig getConfig() {
        return config;
    }

    public static void setConfig(JwtConfig config) {
        JwtManager.config = config;
    }
}

