/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.jwt;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import io.jboot.support.jwt.JwtManager;
import io.jboot.web.controller.JbootController;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class JwtInterceptor
implements Interceptor {
    public static final String ISUUED_AT = "isuuedAt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        try {
            inv.invoke();
        }
        finally {
            JbootController jbootController = (JbootController)inv.getController();
            Map<String, Object> jwtAttrs = jbootController.getJwtAttrs();
            if (jwtAttrs == null) {
                this.refreshIfNecessary(jbootController, jbootController.getJwtParas());
            } else {
                this.responseJwt(jbootController, jwtAttrs);
            }
        }
    }

    private void refreshIfNecessary(Controller controller, Map oldData) {
        if (oldData == null || oldData.isEmpty()) {
            return;
        }
        Long isuuedAtMillis = (Long)oldData.get(ISUUED_AT);
        long validityPeriod = JwtManager.getConfig().getValidityPeriod();
        if (isuuedAtMillis == null || validityPeriod <= 0L) {
            return;
        }
        long savedMillis = System.currentTimeMillis() - isuuedAtMillis;
        if (savedMillis > validityPeriod / 2L) {
            this.responseJwt(controller, oldData);
        }
    }

    private void responseJwt(Controller controller, Map map) {
        String token = JwtManager.me().createJwtToken(map);
        HttpServletResponse response = controller.getResponse();
        response.addHeader(JwtManager.me().getHttpHeaderName(), token);
    }
}

