/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.service;

import com.jfinal.kit.LogKit;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import io.jboot.db.model.Columns;
import io.jboot.db.model.JbootModel;
import io.jboot.service.JbootServiceJoiner;
import io.jboot.service.JbootServiceJoinerImpl;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ObjectFunc;
import io.jboot.utils.ObjectUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JbootServiceBase<M extends JbootModel<M>>
extends JbootServiceJoinerImpl
implements JbootServiceJoiner {
    protected static final int ACTION_ADD = 1;
    protected static final int ACTION_DEL = 2;
    protected static final int ACTION_UPDATE = 3;
    protected JbootModel<M> DAO = this.initDao();

    protected M initDao() {
        Type type = ClassUtil.getUsefulClass(this.getClass()).getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Class modelClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            return (M)((Object)((JbootModel)((Object)ClassUtil.newInstance(modelClass, false))));
        }
        LogKit.warn((String)("Not define Model class in Servlce: " + ClassUtil.getUsefulClass(this.getClass())));
        return null;
    }

    public JbootModel getDao() {
        return this.DAO;
    }

    public M findById(Object id) {
        return (M)this.DAO.findById(id);
    }

    public M findFirstByColumns(Columns columns) {
        return this.findFirstByColumns(columns, null);
    }

    public M findFirstByColumns(Columns columns, String orderBy) {
        return this.DAO.findFirstByColumns(columns, orderBy);
    }

    public List<M> findAll() {
        return this.DAO.findAll();
    }

    public List<M> findListByColumns(Columns columns) {
        return this.DAO.findListByColumns(columns);
    }

    public List<M> findListByColumns(Columns columns, String orderBy) {
        return this.DAO.findListByColumns(columns, orderBy);
    }

    public List<M> findListByColumns(Columns columns, Integer count) {
        return this.DAO.findListByColumns(columns, count);
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count) {
        return this.DAO.findListByColumns(columns, orderBy, count);
    }

    public List<M> findListByIds(Object ... ids) {
        return this.DAO.findListByIds(ids);
    }

    public long findCountByColumns(Columns columns) {
        return this.DAO.findCountByColumns(columns);
    }

    public boolean deleteById(Object id) {
        boolean result = this.DAO.deleteById(id);
        if (result) {
            this.shouldUpdateCache(2, null, id);
        }
        return result;
    }

    public boolean delete(M model) {
        boolean result = ((JbootModel)((Object)model)).delete();
        if (result) {
            this.shouldUpdateCache(2, (Model)model, ((JbootModel)((Object)model))._getIdValue());
        }
        return result;
    }

    public boolean batchDeleteByIds(Object ... ids) {
        boolean result = this.DAO.batchDeleteByIds(ids);
        if (result) {
            for (Object id : ids) {
                this.shouldUpdateCache(2, null, id);
            }
        }
        return result;
    }

    public Object save(M model) {
        boolean result = ((JbootModel)((Object)model)).save();
        if (result) {
            this.shouldUpdateCache(1, (Model)model, ((JbootModel)((Object)model))._getIdValue());
            return ((JbootModel)((Object)model))._getIdValue();
        }
        return null;
    }

    public Object saveOrUpdate(M model) {
        if (((JbootModel)((Object)model))._getIdValue() == null) {
            return this.save(model);
        }
        if (this.update(model)) {
            return ((JbootModel)((Object)model))._getIdValue();
        }
        return null;
    }

    public boolean update(M model) {
        boolean result = ((JbootModel)((Object)model)).update();
        if (result) {
            this.shouldUpdateCache(3, (Model)model, ((JbootModel)((Object)model))._getIdValue());
        }
        return result;
    }

    public Page<M> paginate(int page, int pageSize) {
        return this.DAO.paginate(page, pageSize);
    }

    public Page<M> paginateByColumns(int page, int pageSize, Columns columns) {
        return this.DAO.paginateByColumns(page, pageSize, columns);
    }

    public Page<M> paginateByColumns(int page, int pageSize, Columns columns, String orderBy) {
        return this.DAO.paginateByColumns(page, pageSize, columns, orderBy);
    }

    public void syncModels(Columns columns, Collection<M> syncModels, ObjectFunc<M> ... compareAttrGetters) {
        if (columns == null) {
            throw new NullPointerException("columns must not be null");
        }
        if (syncModels == null || syncModels.isEmpty()) {
            this.DAO.deleteByColumns(columns);
            return;
        }
        List<M> existModels = this.findListByColumns(columns);
        if (existModels == null || existModels.isEmpty()) {
            Db.batchSave(new ArrayList<M>(syncModels), (int)syncModels.size());
            return;
        }
        for (JbootModel existModel : existModels) {
            if (ObjectUtil.isContainsObject(syncModels, existModel, compareAttrGetters)) continue;
            existModel.delete();
        }
        for (JbootModel syncModel : syncModels) {
            JbootModel existModel = ObjectUtil.getContainsObject(existModels, syncModel, compareAttrGetters);
            if (existModel == null) {
                syncModel.save();
                continue;
            }
            ((JbootModel)existModel._setAttrs(syncModel)).update();
        }
    }

    @Override
    protected JbootModel joinByValue(Object columnValue, JbootModel sourceModel) {
        return this.findById(columnValue);
    }

    public void shouldUpdateCache(int action, Model model, Object id) {
    }

    @Override
    protected <M extends JbootModel> List<M> joinManyByValue(String columnName, Object value, M sourceModel) {
        return this.findListByColumns(Columns.create(columnName, value));
    }
}

