/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.objects.lock.impl;

import io.jboot.objects.lock.JbootLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class JbootRedisLock
implements JbootLock {
    private io.jboot.support.redis.JbootRedisLock lock;
    private String name;

    public JbootRedisLock(String name) {
        this.name = name;
        this.lock = new io.jboot.support.redis.JbootRedisLock(name);
    }

    @Override
    public void lock() {
        this.lock.setTimeoutMsecs(60000L);
        if (!this.lock.acquire()) {
            throw new IllegalStateException("can not get lock in JbootRedisLock");
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        return this.lock.acquire();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        this.lock.setTimeoutMsecs(unit.toMillis(time));
        return this.lock.acquire();
    }

    @Override
    public void unlock() {
        this.lock.release();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

