/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.objects.lock.impl;

import io.jboot.objects.lock.JbootLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JbootLocalLock
implements JbootLock {
    private static Map<String, ReentrantLock> LOCKS = new HashMap<String, ReentrantLock>();
    private ReentrantLock lock;

    public JbootLocalLock(String name) {
        this.lock = LOCKS.get(name);
        if (this.lock == null) {
            ReentrantLock newLock = new ReentrantLock();
            LOCKS.putIfAbsent(name, newLock);
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(time, unit);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

