/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.transactional;

import com.jfinal.aop.Invocation;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.NamedThreadFactory;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class TransactionalManager {
    private static TransactionalManager instance = new TransactionalManager();
    private Map<String, ExecutorService> executorServiceMap = new ConcurrentHashMap<String, ExecutorService>();
    private ThreadFactory threadFactory = new NamedThreadFactory("Transactional", true);
    private boolean runDefaultWithoutConfigName = false;

    public static TransactionalManager me() {
        return instance;
    }

    public void addExecutorService(String name, ExecutorService service) {
        this.executorServiceMap.put(name, service);
    }

    public ExecutorService getExecutorService(String name) {
        return this.executorServiceMap.get(name);
    }

    public void removeExecutorService(String name) {
        this.executorServiceMap.remove(name);
    }

    public Map<String, ExecutorService> getExecutorServiceMap() {
        return this.executorServiceMap;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public boolean isRunDefaultWithoutConfigName() {
        return this.runDefaultWithoutConfigName;
    }

    public void setRunDefaultWithoutConfigName(boolean runDefaultWithoutConfigName) {
        this.runDefaultWithoutConfigName = runDefaultWithoutConfigName;
    }

    public Future<Boolean> execute(String byName, Callable<Boolean> callable, Invocation inv) {
        if (StrUtil.isBlank((String)byName)) {
            FutureTask<Boolean> task = new FutureTask<Boolean>(callable);
            this.threadFactory.newThread(task).start();
            return task;
        }
        ExecutorService executorService = this.executorServiceMap.get(byName);
        if (executorService != null) {
            return executorService.submit(callable);
        }
        if (!this.runDefaultWithoutConfigName) {
            throw new IllegalStateException("Can not find threadPoolName: \"" + byName + "\" for @Transactional() in method: " + ClassUtil.buildMethodString(inv.getMethod()) + ".\n Please invoke TransactionalManager.me().addExecutorService() to configure transactional threadPool on application started.");
        }
        FutureTask<Boolean> task = new FutureTask<Boolean>(callable);
        this.threadFactory.newThread(task).start();
        return task;
    }
}

