/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.transactional;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.Ret;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.IAtom;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.aop.annotation.Transactional;
import io.jboot.db.transactional.TransactionalManager;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@AutoLoad
public class TransactionalInterceptor
implements Interceptor,
InterceptorBuilder {
    public void intercept(Invocation inv) {
        Transactional transactional = inv.getMethod().getAnnotation(Transactional.class);
        String configName = AnnotationUtil.get(transactional.config());
        DbPro dbPro = StrUtil.isBlank((String)configName) ? Db.use() : Db.use((String)configName);
        Config config = StrUtil.isBlank((String)configName) ? DbKit.getConfig() : DbKit.getConfig((String)configName);
        int transactionLevel = transactional.transactionLevel();
        if (transactionLevel == -1) {
            transactionLevel = config.getTransactionLevel();
        }
        IAtom runnable = () -> {
            try {
                inv.invoke();
            }
            catch (Throwable ex) {
                for (Class<? extends Throwable> forClass : transactional.noRollbackFor()) {
                    if (!ex.getClass().isAssignableFrom(forClass)) continue;
                    LogKit.error((String)ex.toString(), (Throwable)ex);
                    return true;
                }
                throw ex;
            }
            if (inv.getMethod().getReturnType() == Void.TYPE) {
                return true;
            }
            Object result = inv.getReturnValue();
            if (result == null && transactional.rollbackForNull()) {
                return false;
            }
            if (result instanceof Boolean && !((Boolean)result).booleanValue() && transactional.rollbackForFalse()) {
                return false;
            }
            return !(result instanceof Ret) || !((Ret)result).isFail() || !transactional.rollbackForRetFail();
        };
        if (!inv.isActionInvocation() && transactional.inNewThread()) {
            try {
                Future<Boolean> future = this.txInNewThread(inv, transactional.threadPoolName(), dbPro, transactionLevel, runnable);
                if (inv.getMethod().getReturnType() != Void.TYPE || transactional.threadWithBlocked()) {
                    Boolean bl = future.get();
                }
            }
            catch (Exception e) {
                LogKit.error((String)e.toString(), (Throwable)e);
            }
        } else {
            dbPro.tx(transactionLevel, runnable);
        }
    }

    public Future<Boolean> txInNewThread(Invocation inv, String name, DbPro dbPro, int transactionLevel, IAtom atom) {
        Callable<Boolean> callable = () -> dbPro.tx(transactionLevel, atom);
        return TransactionalManager.me().execute(name, callable, inv);
    }

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (InterceptorBuilder.Util.hasAnnotation(method, Transactional.class)) {
            interceptors.add(this);
        }
    }
}

